<?php
/*
Plugin Name: Wordpress vCard
Plugin URI: http://www.simondalfonso.id.au/blog/?p=30
Description: Generates vCard information
Version: 0.1
Author: Simon D'Alfonso (sjdalf)
Author URI: http://simondalfonso.id.au/
*/

/*  Copyright 2007 Simon D'Alfonso  (email : simon.dalfonso@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    For more information, see http://www.gnu.org/copyleft/gpl.html
*/

/*---------------------------------------------------------------------------*/

include('xml.php');

function prepareXMLString($strInput) {
	$strReturn = $strInput;
	$strReturn = str_replace("\'", "'", $strReturn);
	return $strReturn;
}

function wpvcard_writevCard() {

	$data = implode(file(get_bloginfo ( 'home'  )."/wp-content/plugins/vcard/vcard.xml"));
	$xml_vcard = XML_unserialize($data);

	echo "BEGIN:VCARD\n";
	echo "VERSION:2.1\n";
	echo "N:".$xml_vcard['vcards']['vcard']['n_3'].";".$xml_vcard['vcards']['vcard']['n_1'].";".$xml_vcard['vcards']['vcard']['n_2'].";".$xml_vcard['vcards']['vcard']['n_4']."\n";
	echo "FN:".$xml_vcard['vcards']['vcard']['fn']."\n";
	echo "NICKNAME:".$xml_vcard['vcards']['vcard']['nickname']."\n";
	echo "ORG:".$xml_vcard['vcards']['vcard']['org'].";".$xml_vcard['vcards']['vcard']['department']."\n";
	echo "TITLE:".$xml_vcard['vcards']['vcard']['title']."\n";
	echo "TEL;WORK;VOICE:".$xml_vcard['vcards']['vcard']['business_phone']."\n";
	echo "TEL;HOME;VOICE:".$xml_vcard['vcards']['vcard']['home_phone']."\n";
	echo "TEL;CELL;VOICE:".$xml_vcard['vcards']['vcard']['home_mobile']."\n";
	echo "TEL;WORK;FAX:".$xml_vcard['vcards']['vcard']['business_fax']."\n";
	echo "TEL;HOME;FAX:".$xml_vcard['vcards']['vcard']['home_fax']."\n";
	echo "ADR;WORK:;".$xml_vcard['vcards']['vcard']['office'].";".$xml_vcard['vcards']['vcard']['business_address'].";".$xml_vcard['vcards']['vcard']['business_city'].";".$xml_vcard['vcards']['vcard']['business_state'].";".$xml_vcard['vcards']['vcard']['business_zip'].";".$xml_vcard['vcards']['vcard']['business_country']."\n";
	echo "ADR;HOME:;;".$xml_vcard['vcards']['vcard']['home_address'].";".$xml_vcard['vcards']['vcard']['home_city'].";".$xml_vcard['vcards']['vcard']['home_state'].";".$xml_vcard['vcards']['vcard']['home_zip'].";".$xml_vcard['vcards']['vcard']['home_country']."\n";
	echo "URL;HOME:".$xml_vcard['vcards']['vcard']['url_home']."\n";
	echo "URL;WORK:".$xml_vcard['vcards']['vcard']['url_work']."\n";
	echo "EMAIL;PREF;INTERNET:".$xml_vcard['vcards']['vcard']['email']."\n";
	echo "END:VCARD";

}

function wpvcard_vcard_page() {

	if($_POST['hddn_Save'] == "true") {

		$vcard_data = array();

		$vcard_data['vcards']['vcard']['business_address'] = prepareXMLString($_POST['txt_business_address']);
		$vcard_data['vcards']['vcard']['business_city'] = prepareXMLString($_POST['txt_business_city']);
		$vcard_data['vcards']['vcard']['business_country'] = prepareXMLString($_POST['txt_business_country']);
		$vcard_data['vcards']['vcard']['business_fax'] = prepareXMLString($_POST['num_business_fax']);
		$vcard_data['vcards']['vcard']['business_phone'] = prepareXMLString($_POST['num_business_phone']);
		$vcard_data['vcards']['vcard']['business_state'] = prepareXMLString($_POST['txt_business_state']);
		$vcard_data['vcards']['vcard']['business_zip'] = prepareXMLString($_POST['num_business_zip']);
		$vcard_data['vcards']['vcard']['email'] = prepareXMLString($_POST['txt_email']);
		$vcard_data['vcards']['vcard']['fn'] = prepareXMLString($_POST['txt_fn']);
		$vcard_data['vcards']['vcard']['home_address'] = prepareXMLString($_POST['txt_home_address']);
		$vcard_data['vcards']['vcard']['home_city'] = prepareXMLString($_POST['txt_home_city']);
		$vcard_data['vcards']['vcard']['home_country'] = prepareXMLString($_POST['txt_home_country']);
		$vcard_data['vcards']['vcard']['home_fax'] = prepareXMLString($_POST['num_home_fax']);
		$vcard_data['vcards']['vcard']['home_mobile'] = prepareXMLString($_POST['num_home_mobile']);
		$vcard_data['vcards']['vcard']['home_phone'] = prepareXMLString($_POST['num_home_phone']);
		$vcard_data['vcards']['vcard']['home_state'] = prepareXMLString($_POST['txt_home_state']);
		$vcard_data['vcards']['vcard']['home_zip'] = prepareXMLString($_POST['num_home_zip']);
		$vcard_data['vcards']['vcard']['n_1'] = prepareXMLString($_POST['txt_n_1']);
		$vcard_data['vcards']['vcard']['n_2'] = prepareXMLString($_POST['txt_n_2']);
		$vcard_data['vcards']['vcard']['n_3'] = prepareXMLString($_POST['txt_n_3']);
		$vcard_data['vcards']['vcard']['n_4'] = prepareXMLString($_POST['txt_n_4']);
		$vcard_data['vcards']['vcard']['nickname'] = prepareXMLString($_POST['txt_nickname']);
		$vcard_data['vcards']['vcard']['org'] = prepareXMLString($_POST['txt_org']);
		$vcard_data['vcards']['vcard']['office'] = prepareXMLString($_POST['txt_office']);
		$vcard_data['vcards']['vcard']['department'] = prepareXMLString($_POST['txt_department']);
		$vcard_data['vcards']['vcard']['title'] = prepareXMLString($_POST['txt_title']);
		$vcard_data['vcards']['vcard']['url_home'] = prepareXMLString($_POST['txt_url_home']);
		$vcard_data['vcards']['vcard']['url_work'] = prepareXMLString($_POST['txt_url_work']);
		
		$xml = XML_serialize($vcard_data);

		$handle = fopen("../wp-content/plugins/vcard/vcard.xml", 'w+');
		$result = fwrite($handle, $xml);
		fclose($handle);
	}

	$data = implode(file(get_bloginfo ( 'home'  )."/wp-content/plugins/vcard/vcard.xml"));
	$xml_vcard = XML_unserialize($data);

?>
	<form name="frmvCard" action="" method="POST">
	<div class="wrap">
	<h2>vCard Details</h2>
	<table class="editform">
	<tr><td>First Name:</td><td><input type="text" name="txt_n_1" value="<?php echo prepareXMLString($xml_vcard['vcards']['vcard']['n_1']) ?>" onChange="frmvCard.txt_fn.value=frmvCard.txt_n_1.value+' '+frmvCard.txt_n_3.value;" /></td></tr>
	<tr><td>Middle Name:</td><td><input type="text" name="txt_n_2" value="<?php echo $xml_vcard['vcards']['vcard']['n_2'] ?>" /></td></tr>
	<tr><td>Last Name:</td><td><input type="text" name="txt_n_3" value="<?php echo $xml_vcard['vcards']['vcard']['n_3'] ?>" onChange="frmvCard.txt_fn.value=frmvCard.txt_n_1.value+' '+frmvCard.txt_n_3.value;" /></td></tr>
	<tr><td>Title:</td><td><input type="text" name="txt_n_4" value="<?php echo $xml_vcard['vcards']['vcard']['n_4'] ?>" /></td></tr>
	<tr><td>Display Name:</td><td><input type="text" name="txt_fn" value="<?php echo $xml_vcard['vcards']['vcard']['fn'] ?>" /></td></tr>
	<tr><td>Nickname:</td><td><input type="text" name="txt_nickname" value="<?php echo $xml_vcard['vcards']['vcard']['nickname'] ?>" /></td></tr>
	<tr><td>Email:</td><td><input type="text" name="txt_email" value="<?php echo $xml_vcard['vcards']['vcard']['email'] ?>" /></td></tr>
	<tr><td colspan="2">&nbsp;</td></tr>
	<tr><td colspan="2"><b>Home</b></td></tr>
	<tr><td>Address:</td><td><input type="text" name="txt_home_address" value="<?php echo $xml_vcard['vcards']['vcard']['home_address'] ?>" /></td></tr>
	<tr><td>City:</td><td><input type="text" name="txt_home_city" value="<?php echo $xml_vcard['vcards']['vcard']['home_city'] ?>" /></td></tr>
	<tr><td>State:</td><td><input type="text" name="txt_home_state" value="<?php echo $xml_vcard['vcards']['vcard']['home_state'] ?>" /></td></tr>
	<tr><td>Zip Code:</td><td><input type="text" name="num_home_zip" value="<?php echo $xml_vcard['vcards']['vcard']['home_zip'] ?>" /></td></tr>
	<tr><td>Country:</td><td><input type="text" name="txt_home_country" value="<?php echo $xml_vcard['vcards']['vcard']['home_country'] ?>" /></td></tr>
	<tr><td>Phone:</td><td><input type="text" name="num_home_phone" value="<?php echo $xml_vcard['vcards']['vcard']['home_phone'] ?>" /></td></tr>
	<tr><td>Fax:</td><td><input type="text" name="num_home_fax" value="<?php echo $xml_vcard['vcards']['vcard']['home_fax'] ?>" /></td></tr>
	<tr><td>Mobile:</td><td><input type="text" name="num_home_mobile" value="<?php echo $xml_vcard['vcards']['vcard']['home_mobile'] ?>" /></td></tr>
	<tr><td>Web Page:</td><td><input type="text" name="txt_url_home" value="<?php echo $xml_vcard['vcards']['vcard']['url_home'] ?>" /></td></tr>
	<tr><td colspan="2">&nbsp;</td></tr>
	<tr><td colspan="2"><b>Business</b></td></tr>
	<tr><td>Company:</td><td><input type="text" name="txt_org" value="<?php echo $xml_vcard['vcards']['vcard']['org'] ?>" /></td></tr>
	<tr><td>Job Title:</td><td><input type="text" name="txt_title" value="<?php echo $xml_vcard['vcards']['vcard']['title'] ?>" /></td></tr>
	<tr><td>Department:</td><td><input type="text" name="txt_department" value="<?php echo $xml_vcard['vcards']['vcard']['department'] ?>" /></td></tr>
	<tr><td>Office:</td><td><input type="text" name="txt_office" value="<?php echo $xml_vcard['vcards']['vcard']['office'] ?>" /></td></tr>
	<tr><td>Address:</td><td><input type="text" name="txt_business_address" value="<?php echo $xml_vcard['vcards']['vcard']['business_address'] ?>" /></td></tr>
	<tr><td>City:</td><td><input type="text" name="txt_business_city" value="<?php echo $xml_vcard['vcards']['vcard']['business_city'] ?>" /></td></tr>
	<tr><td>State:</td><td><input type="text" name="txt_business_state" value="<?php echo $xml_vcard['vcards']['vcard']['business_state'] ?>" /></td></tr>
	<tr><td>Zip Code:</td><td><input type="text" name="num_business_zip" value="<?php echo $xml_vcard['vcards']['vcard']['business_zip'] ?>" /></td></tr>
	<tr><td>Country:</td><td><input type="text" name="txt_business_country" value="<?php echo $xml_vcard['vcards']['vcard']['business_country'] ?>" /></td></tr>
	<tr><td>Phone:</td><td><input type="text" name="num_business_phone" value="<?php echo $xml_vcard['vcards']['vcard']['business_phone'] ?>" /></td></tr>
	<tr><td>Fax:</td><td><input type="text" name="num_business_fax" value="<?php echo $xml_vcard['vcards']['vcard']['business_fax'] ?>" /></td></tr>
	<tr><td>Web Page:</td><td><input type="text" name="txt_url_work" value="<?php echo $xml_vcard['vcards']['vcard']['url_work'] ?>" /></td></tr>
	<tr><td>&nbsp;</td><td><input type="submit" name="sbmt_vCard" value="Save Details" /></td></tr>
	</table>
	<input type="hidden" name="hddn_Save" value="true" />
	</div>
	</form>
<?php
}

function wpvcard_add_vcard_page() {
    add_options_page('vCard Details', 'vCard Details', 8, 'vCard', 'wpvcard_vcard_page');
}

add_action('admin_menu', 'wpvcard_add_vcard_page');

//---------------------------------------------------------------------------//

function wpvcard_displayvCardLink() {
?>
	<a href="<?php echo get_option('home'); ?>/wp-vcard.php" target="_blank"><img src="<?php echo get_option('home'); ?>/wp-content/plugins/vcard/vcard-icon.jpg" alt="vCard" title="vCard" style="border:0px;" /></a>
<?php

}


// Put functions into one big function we'll call at the plugins_loaded
// action. This ensures that all required plugin functions are defined.
function widget_vcard_init() {

	// Check for the required plugin functions. This will prevent fatal
	// errors occurring when you deactivate the dynamic-sidebar plugin.
	if ( !function_exists('register_sidebar_widget') )
		return;

	// This is the function that outputs vCard icon link.
	function widget_vcard() {
		// These lines generate our output. Widgets can be very complex
		// but as you can see here, they can also be very, very simple.
		echo $before_widget . $before_title . $title . $after_title;
		echo '<div class="menublock"><a href="'.get_option('home').'/wp-vcard.php" target="_blank"><img src="'.get_option('home').'/wp-content/plugins/vcard/vcard-icon.jpg" alt="vCard" title="vCard" style="border:0px;" /></a></div>';
		echo $after_widget;
	}

	// This registers our widget so it appears with the other available
	// widgets and can be dragged and dropped into any active sidebars.
	register_sidebar_widget(array('vCard', 'widgets'), 'widget_vcard');
}

// Run our code later in case this loads prior to any required plugins.
add_action('widgets_init', 'widget_vcard_init');
?>