<?php
/**
* Turkish (tr) translation file.
*  
* @author Nick Korbel <lqqkout13@users.sourceforge.net>
* @translator zcan doan <ozcandogan@gmail.com>
* @version 05-14-06
* @package Languages
*
* Copyright (C) 2003 - 2007 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
// Please save the translated file as '2 letter language code'.lang.php.  For example, en.lang.php.
// 
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  If there
//  is no direct translation, please provide the closest translation.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//  Also, please add a help translation for your language using en.help.php as a base.
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'iso-8859-9';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element 
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('Pazar', 'Pazartesi', 'Sal', 'aramba', 'Perembe', 'Cuma', 'Cumartesi');
// The three letter abbreviation
$days_abbr = array('Paz', 'Pts', 'Sal', 'ar', 'Per', 'Cum', 'Cts');
// The two letter abbreviation
$days_two  = array('Pa', 'Pt', 'Sa', 'a', 'Pe', 'Cu', 'Ct');
// The one letter abbreviation
$days_letter = array('P', 'P', 'S', '', 'P', 'C', 'C');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('Ocak', 'ubat', 'Mart', 'Nisan', 'Mays', 'Haziran', 'Temmuz', 'Austos', 'Eyll', 'Ekim', 'Kasm', 'Aralk');
// The three letter month name
$months_abbr = array('Oca', 'ub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Agu', 'Eyl', 'Eki', 'Kas', 'Ara');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%m/%d/%Y';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%m/%d/%Y @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%A %m/%d/%Y';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%A,<br/>%m/%d/%Y';
// Date on top-right of each page
$dates['header'] = '%A, %B %d, %Y';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box 
$dates['jumpbox'] = '%m %d %Y';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'saat';
$strings['minutes'] = 'dakika';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'mm';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'dd';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = 'yyyy';
$strings['am'] = 'am';
$strings['pm'] = 'pm';

$strings['Administrator'] = 'Administrator';
$strings['Welcome Back'] = 'Hogeldiniz, %s';
$strings['Log Out'] = 'k';
$strings['My Control Panel'] = 'Denetim Masam';
$strings['Help'] = 'Yardm';
$strings['Manage Schedules'] = 'izelgeyi Ynet';
$strings['Manage Users'] = 'Kullanclar Ynet';
$strings['Manage Resources'] = 'Kaynaklar Ynet';
$strings['Manage User Training'] = 'Kullanc eitimi ynet';
$strings['Manage Reservations'] = 'Rezervasyonlar ynet';
$strings['Email Users'] = 'Kullanclara eposta gnder';
$strings['Export Database Data'] = 'Veritaban ihra';
$strings['Reset Password'] = 'ifreyi sfrla';
$strings['System Administration'] = 'Sistem ynetimi';
$strings['Successful update'] = 'Gncelletirme baarl';
$strings['Update failed!'] = 'Gncelletirme baarsz';
$strings['Manage Blackout Times'] = 'Uygun olmayan zamanlar ynet';
$strings['Forgot Password'] = 'ifreyi unuttum';
$strings['Manage My Email Contacts'] = 'Posta listemi ynet';
$strings['Choose Date'] = 'Tarih Se';
$strings['Modify My Profile'] = 'Profilimi deitir';
$strings['Register'] = 'Kayt Ol';
$strings['Processing Blackout'] = 'Uygun olmayan zaman ileniyor';
$strings['Processing Reservation'] = 'rezervasyon ileniyor';
$strings['Online Scheduler [Read-only Mode]'] = 'izelge Gster [salt okunur]';
$strings['Online Scheduler'] = 'izelge';
$strings['phpScheduleIt Statistics'] = 'statistik';
$strings['User Info'] = 'Kullanc Bilgisi:';

$strings['Could not determine tool'] = 'Ara tanmlanamad. Denetim masasna dnp tekrar deneyiniz.';
$strings['This is only accessable to the administrator'] = 'Sadece admin yetkili';
$strings['Back to My Control Panel'] = 'Denetim masasna dn';
$strings['That schedule is not available.'] = 'Bu izelge uygun deil';
$strings['You did not select any schedules to delete.'] = 'Silmek iin izelge semediniz';
$strings['You did not select any members to delete.'] = 'Silmek iin ye semediniz.';
$strings['You did not select any resources to delete.'] = 'Silmek iin kaynak semediniz';
$strings['Schedule title is required.'] = 'izelge bal gerekli.';
$strings['Invalid start/end times'] = 'Geersiz balang/biti zamanlar';
$strings['View days is required'] = 'Gn gerekli';
$strings['Day offset is required'] = 'offset gn gerekli';
$strings['Admin email is required'] = 'Admin eposta gerekli';
$strings['Resource name is required.'] = 'Kaynak ad gerekli';
$strings['Valid schedule must be selected'] = 'Geerli izelge seilmeli';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'En az rezervasyon sresi en ok rezervasyon sresinden az ya da eit olmaldr.';
$strings['Your request was processed successfully.'] = 'steiniz baaryla ilendi.';
$strings['Go back to system administration'] = 'Sistem ynetimine geri dn';
$strings['Or wait to be automatically redirected there.'] = 'Veya oraya ynlendirilmek iin bekleyin.';
$strings['There were problems processing your request.'] = 'lemde hata var.';
$strings['Please go back and correct any errors.'] = 'Ltfen geri dnn ve hatalar dzeltin.';
$strings['Login to view details and place reservations'] = 'Giri yapnz';
$strings['Memberid is not available.'] = 'ye: %s geerli deil.';

$strings['Schedule Title'] = 'izelge bal';
$strings['Start Time'] = 'Balang zaman';
$strings['End Time'] = 'Biti zaman';
$strings['Time Span'] = 'Sre';
$strings['Weekday Start'] = 'Hafta Ba';
$strings['Admin Email'] = 'Admin Eposta';

$strings['Default'] = 'varsaylan';
$strings['Reset'] = 'Yenile';
$strings['Edit'] = 'Dzenle';
$strings['Delete'] = 'Sil';
$strings['Cancel'] = 'ptal';
$strings['View'] = 'Gster';
$strings['Modify'] = 'Deitir';
$strings['Save'] = 'Kaydet';
$strings['Back'] = 'Geri';
$strings['Next'] = 'leri';
$strings['Close Window'] = 'Pancereyi kapat';
$strings['Search'] = 'Ara';
$strings['Clear'] = 'Temizle';

$strings['Days to Show'] = 'Gsterilecek gn';
$strings['Reservation Offset'] = 'Rezervasyon Offset';
$strings['Hidden'] = 'sakl';
$strings['Show Summary'] = 'zet Gzter';
$strings['Add Schedule'] = 'izelge ekle';
$strings['Edit Schedule'] = 'izelge dzenle';
$strings['No'] = 'Hayr';
$strings['Yes'] = 'Evet';
$strings['Name'] = 'Ad';
$strings['First Name'] = 'lk ad';
$strings['Last Name'] = 'Soyad';
$strings['Resource Name'] = 'Kaynak ad';
$strings['Email'] = 'Eposta';
$strings['Institution'] = 'Blm';
$strings['Phone'] = 'telefon';
$strings['Password'] = 'ifre';
$strings['Permissions'] = 'zinler';
$strings['View information about'] = 'Hakknda bilgi gster %s %s';
$strings['Send email to'] = 'Posta Yolla %s %s';
$strings['Reset password for'] = 'ifre sfrla %s %s';
$strings['Edit permissions for'] = 'zin deitir %s %s';
$strings['Position'] = 'Grevi';
$strings['Password (6 char min)'] = 'ifre (en az %s karakter)';
$strings['Re-Enter Password'] = 'ifreyi tekrar gir';

$strings['Sort by descending last name'] = 'z\'den a\'ya soyadlara gre srala';
$strings['Sort by descending email address'] = 'z\'den a\'ya Epostaya gre srala';
$strings['Sort by descending institution'] = 'z\'den a\'ya greve gre srala';
$strings['Sort by ascending last name'] = 'a\'dan z\'ye soyada gre srala';
$strings['Sort by ascending email address'] = 'a\'dan z\'ye epostaya gre srala';
$strings['Sort by ascending institution'] = 'a\'dan z\'ye greve gre srala';
$strings['Sort by descending resource name'] = 'z\'den a\'ya kaynak adna gre srala';
$strings['Sort by descending location'] = 'z\'den a\'ya yere gre srala';
$strings['Sort by descending schedule title'] = 'z\'den a\'ya izelge balna gre srala';
$strings['Sort by ascending resource name'] = 'a\'dan z\'ye kaynak adna gre srala';
$strings['Sort by ascending location'] = 'a\'dan z\'ye yere gre srala';
$strings['Sort by ascending schedule title'] = 'a\'dan z\'ye izelge balna gre srala';
$strings['Sort by descending date'] = 'z\'den a\'ya tarihe gre srala';
$strings['Sort by descending user name'] = 'z\'den a\'ya kullanc adna gre srala';
$strings['Sort by descending start time'] = 'z\'den a\'ya balang zamanna gre srala';
$strings['Sort by descending end time'] = 'z\'den a\'ya biti zamanna gre srala';
$strings['Sort by ascending date'] = 'a\'dan z\'ye tarihe gre srala';
$strings['Sort by ascending user name'] = 'a\'dan z\'ye kullanc adna gre srala';
$strings['Sort by ascending start time'] = 'a\'dan z\'ye balang zamanna gre srala';
$strings['Sort by ascending end time'] = 'a\'dan z\'ye biti zamanna gre srala';
$strings['Sort by descending created time'] = 'z\'den a\'ya yaratld zamanna gre srala';
$strings['Sort by ascending created time'] = 'a\'dan z\'ye yaratld zamanna gre srala';
$strings['Sort by descending last modified time'] = 'z\'den a\'ya son deitirildii zamana gre srala';
$strings['Sort by ascending last modified time'] = 'a\'dan z\'ye son deitirildii zamana gre srala';

$strings['Search Users'] = 'Kullanc ara';
$strings['Location'] = 'yer';
$strings['Schedule'] = 'izelge';
$strings['Notes'] = 'Notlar';
$strings['Status'] = 'Durum';
$strings['All Schedules'] = 'Tm izelgeler';
$strings['All Resources'] = 'Tm kaynaklar';
$strings['All Users'] = 'Tm kullanclar';

$strings['Edit data for'] = 'Veriyi dzenle %s';
$strings['Active'] = 'Aktif';
$strings['Inactive'] = 'Pasif';
$strings['Toggle this resource active/inactive'] = 'Bu kayna actif/pasif olarak iaretle';
$strings['Minimum Reservation Time'] = 'En ksa rezervasyon sresi';
$strings['Maximum Reservation Time'] = 'En uzun rezervasyon sresi';
$strings['Auto-assign permission'] = 'Otomatik yetkilendir';
$strings['Add Resource'] = 'kaynak ekle';
$strings['Edit Resource'] = 'kaynak dzenle';
$strings['Allowed'] = 'zinli';
$strings['Notify user'] = 'Kullanc bilgilendir';
$strings['User Reservations'] = 'Kullanc rezervasyonlar';
$strings['Date'] = 'Tarih';
$strings['User'] = 'Kullanc';
$strings['Subject'] = 'Konu';
$strings['Message'] = 'Mesaj';
$strings['Please select users'] = 'Kullanc seiniz';
$strings['Send Email'] = 'Eposta gnder';
$strings['problem sending email'] = 'Eposta gndermede hata! Ltfen daha sonra tekrar deneyiniz.';
$strings['The email sent successfully.'] = 'Eposta baaryla gnderildi.';
$strings['do not refresh page'] = 'Ltfen <u>bu sayfay</u> tazelemeyin. Epostay 2. kez gndermi olursunuz.';
$strings['Return to email management'] = 'Eposta ynetimine dn';
$strings['Please select which tables and fields to export'] = 'Ltfen ihra edilecek tablolar seiniz';
$strings['all fields'] = '- Tm alanlar -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Dz metin';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'hra et';
$strings['Reset Password for'] = 'ifreyi sfrla %s';
$strings['Please edit your profile'] = 'Profilinizi dzenleyin';
$strings['Please register'] = 'Ltfen kayt olun';
$strings['Email address (this will be your login)'] = 'Eposta adresi (kullanc adnz olacak)';
$strings['Keep me logged in'] = 'ifre kaydet <br/>(erez gerektirir)';
$strings['Edit Profile'] = 'Profil dzenle';
$strings['Please Log In'] = 'Giri Yapnz';
$strings['Email address'] = 'Eposta';
$strings['First time user'] = 'lk kez kullancs?';
$strings['Click here to register'] = 'kayt iin tklaynz';
$strings['Register for phpScheduleIt'] = 'Kayt olunuz';
$strings['Log In'] = 'Giri';
$strings['View Schedule'] = 'izelgeyi gster';
$strings['View a read-only version of the schedule'] = 'salt okunur izelge';
$strings['I Forgot My Password'] = 'ifremi Unuttum';
$strings['Retreive lost password'] = 'ifremi gnder';
$strings['Get online help'] = 'yardm';
$strings['Language'] = 'Dil';
$strings['(Default)'] = '(varsaylan)';

$strings['My Announcements'] = 'Duyurularm';
$strings['My Reservations'] = 'Rezervasyonlarm';
$strings['My Permissions'] = 'izinlerim';
$strings['My Quick Links'] = 'Kprlerim';
$strings['Announcements as of'] = 'Duyurular %s';
$strings['There are no announcements.'] = 'Duyuru Yok';
$strings['Resource'] = 'Kaynak';
$strings['Created'] = 'Yaratld';
$strings['Last Modified'] = 'Son deitirme';
$strings['View this reservation'] = 'Bu rezervasyonu gster';
$strings['Modify this reservation'] = 'Bu rezervasyonu deitir';
$strings['Delete this reservation'] = 'Bu rezervasyonu sil';
$strings['Bookings'] = 'Yer ayrma';											// @since 1.2.0
$strings['Change My Profile Information/Password'] = 'Profil deitir';		// @since 1.2.0
$strings['Manage My Email Preferences'] = 'Eposta Seenekleri';				// @since 1.2.0
$strings['Mass Email Users'] = 'Kullanclara eposta gnder';
$strings['Search Scheduled Resource Usage'] = 'Rezervasyon ara';		// @since 1.2.0
$strings['Export Database Content'] = 'Veritaban ihra et';
$strings['View System Stats'] = 'Sistem istatistikleri';
$strings['Email Administrator'] = 'Epostal Administrator';

$strings['Email me when'] = 'eposta gnderme zaman:';
$strings['I place a reservation'] = 'Rezervasyon yaparm';
$strings['My reservation is modified'] = 'Rezervasyonum deitirildi';
$strings['My reservation is deleted'] = 'Rezervasyonum silindi';
$strings['I prefer'] = 'tercihim:';
$strings['Your email preferences were successfully saved'] = 'Eposta tercihleriniz kaydedildi!';
$strings['Return to My Control Panel'] = 'Denetim masasna dn';

$strings['Please select the starting and ending times'] = 'Balan ve biti zaman seiniz:';
$strings['Please change the starting and ending times'] = 'Balan ve biti zaman deitirin:';
$strings['Reserved time'] = 'Rezerv zaman:';
$strings['Minimum Reservation Length'] = 'En ksa rezervasyon sresi:';
$strings['Maximum Reservation Length'] = 'En uzun rezervasyon sresi:';
$strings['Reserved for'] = 'Rezervasyon sahibi:';
$strings['Will be reserved for'] = 'rezerve edilecei kii:';
$strings['N/A'] = 'N/A';
$strings['Update all recurring records in group'] = 'Gruptaki tm tekrarlayan kaytlar gncelle?';
$strings['Delete?'] = 'sil?';
$strings['Never'] = '-- Hi --';
$strings['Days'] = 'Gn';
$strings['Weeks'] = 'Hafta';
$strings['Months (date)'] = 'Aylar (tarih)';
$strings['Months (day)'] = 'haftalar (gn)';
$strings['First Days'] = 'Birinci Gnler';
$strings['Second Days'] = 'kinci Gnler';
$strings['Third Days'] = 'nc Gnler';
$strings['Fourth Days'] = 'Drdnc Gnler';
$strings['Last Days'] = 'Son Gnler';
$strings['Repeat every'] = 'Tekrar skl:';
$strings['Repeat on'] = 'Tekrar:';
$strings['Repeat until date'] = 'Tekrar sonu:';
$strings['Summary'] = 'zet';

$strings['View schedule'] = 'izelge Gster:';
$strings['My Past Reservations'] = 'Eski rezervasyonlar';
$strings['Other Reservations'] = 'Dier rezervasyonlar';
$strings['Other Past Reservations'] = 'Dier eski rezervasyonlar';
$strings['Blacked Out Time'] = 'Uygun olmayan zaman';
$strings['Set blackout times'] = 'Uygun olmayan zaman ayarla %s on %s';
$strings['Reserve on'] = 'Rezerve %s on %s';
$strings['Prev Week'] = ' Geen hafta';
$strings['Jump 1 week back'] = '1 Hafta geri';
$strings['Prev days'] = ' nceki %d gn';
$strings['Previous days'] = ' nceki %d gn';
$strings['This Week'] = 'Bu hafta';
$strings['Jump to this week'] = 'Bu haftaya dn';
$strings['Next days'] = 'Sonraki %d gn ';
$strings['Next Week'] = 'Gelecek hafta ';
$strings['Jump To Date'] = 'Tarihe Git';
$strings['View Monthly Calendar'] = 'Aylk takvimi gster';
$strings['Open up a navigational calendar'] = 'Dolaml takvim a';

$strings['View stats for schedule'] = 'izelge istatistikleri:';
$strings['At A Glance'] = 'Bakta';
$strings['Total Users'] = 'Toplam kullanc:';
$strings['Total Resources'] = 'Toplam kaynak:';
$strings['Total Reservations'] = 'Toplam rezervasyon:';
$strings['Max Reservation'] = 'En ok rezervasyon:';
$strings['Min Reservation'] = 'En az rezervasyon:';
$strings['Avg Reservation'] = 'Ortalama rezervasyon:';
$strings['Most Active Resource'] = 'En aktif kaynak:';
$strings['Most Active User'] = 'En aktif kullanc:';
$strings['System Stats'] = 'Sistem istatistikleri';
$strings['phpScheduleIt version'] = 'versiYon:';
$strings['Database backend'] = 'Veritaban arka ucu:';
$strings['Database name'] = 'Veritaban ad:';
$strings['PHP version'] = 'PHP versiyon:';
$strings['Server OS'] = 'Sunucu OS:';
$strings['Server name'] = 'Sunucu ad:';
$strings['phpScheduleIt root directory'] = 'ana dizin:';
$strings['Using permissions'] = 'zinler:';
$strings['Using logging'] = 'Log Kaytlar:';
$strings['Log file'] = 'Log dosyas:';
$strings['Admin email address'] = 'Admin eposta adresi:';
$strings['Tech email address'] = 'Teknisyen eposta adresi:';
$strings['CC email addresses'] = 'CC eposta adres:';
$strings['Reservation start time'] = 'Rezervasyon balang zaman:';
$strings['Reservation end time'] = 'Rezervasyon biti zaman:';
$strings['Days shown at a time'] = 'Bir seferde gsterilecek gn:';
$strings['Reservations'] = 'Rezervasyonlar';
$strings['Return to top'] = 'Yukar dn';
$strings['for'] = 'in';

$strings['Select Search Criteria'] = 'Arama kriteri seiniz';
$strings['Schedules'] = 'izelgeler:';
$strings['Hold CTRL to select multiple'] = 'oklu seim iin CTRL basl tutunuz';
$strings['Users'] = 'Kullanclar:';
$strings['Resources'] = 'Kaynaklar';
$strings['Starting Date'] = 'Balang gn:';
$strings['Ending Date'] = 'Biti Gn:';
$strings['Starting Time'] = 'Balang zaman:';
$strings['Ending Time'] = 'Biti zaman:';
$strings['Output Type'] = 'kt tipi:';
$strings['Manage'] = 'Ynet';
$strings['Total Time'] = 'Toplam sre';
$strings['Total hours'] = 'Toplam saat:';
$strings['% of total resource time'] = '% Toplam rezervasyon sresi';
$strings['View these results as'] = 'Bu sonular gster:';
$strings['Edit this reservation'] = 'Bu rezervasyonu dzenle';
$strings['Search Results'] = 'Arama sonular';
$strings['Search Resource Usage'] = 'kaynak kullanm ara';
$strings['Search Results found'] = 'Arama sonular: %d rezervasyon bulundu';
$strings['Try a different search'] = 'Farkl arama deneyiniz';
$strings['Search Run On'] = 'Arama altrld:';
$strings['Member ID'] = 'ye ID';
$strings['Previous User'] = ' nceki kullanc';
$strings['Next User'] = 'Sonraki kullanc ';

$strings['No results'] = 'Sonu bulunamad';
$strings['That record could not be found.'] = 'O kayt bulunamad.';
$strings['This blackout is not recurring.'] = 'Bu kesinti tekrarlamayacak.';
$strings['This reservation is not recurring.'] = 'Bu rezervasyon tekrarlamayacak.';
$strings['There are no records in the table.'] = 'Tabloda %s kayt yok.';
$strings['You do not have any reservations scheduled.'] = 'yaplm rezervasyonunuz yok';
$strings['You do not have permission to use any resources.'] = 'Kaynak kullanm yetkinniz yok.';
$strings['No resources in the database.'] = 'Veritabannda kaynak yok.';
$strings['There was an error executing your query'] = 'Sorgu altrlrken hata olutu:';

$strings['That cookie seems to be invalid'] = 'erez geersiz';
$strings['We could not find that email in our database.'] = 'Eposta adresniniz bulunamad';
$strings['That password did not match the one in our database.'] = 'hatal ifre.';
$strings['You can try'] = '<br />tekrar farkl:<br />eposta adresi girin.<br />veya:<br />tekrar giri yapn.';
$strings['A new user has been added'] = 'Yeni bir kullanc eklendi';
$strings['You have successfully registered'] = 'baaryla kaydoldunuz!';
$strings['Continue'] = 'Devam...';
$strings['Your profile has been successfully updated!'] = 'Profiliniz baaryla gncellendi!';
$strings['Please return to My Control Panel'] = 'Ltfen denetim masasna dnn';
$strings['Valid email address is required.'] = '- geerli eposta adresi giriniz.';
$strings['First name is required.'] = '- Ad gerekli.';
$strings['Last name is required.'] = '-Soyad gerekli.';
$strings['Phone number is required.'] = '- Telefon no gerekli.';
$strings['That email is taken already.'] = '- Bu eposta kaytl.<br />Ltfen baka eposta deneyiniz.';
$strings['Min 6 character password is required.'] = '- En az 6 karakter ifre gerekli.';
$strings['Passwords do not match.'] = '- ifreler tutarsz.';

$strings['Per page'] = 'sayfa bana:';
$strings['Page'] = 'sayfa:';

$strings['Your reservation was successfully created'] = 'Rezervasyonunuz baaryla yaratld';
$strings['Your reservation was successfully modified'] = 'Rezervasyonunuz baaryla deitirildi';
$strings['Your reservation was successfully deleted'] = 'Rezervasyonunuz baaryla silindi';
$strings['Your blackout was successfully created'] = 'Kesintiniz yaratld.';
$strings['Your blackout was successfully modified'] = 'Kesintiniz deitirildi';
$strings['Your blackout was successfully deleted'] = 'Kesintiniz silindi';
$strings['for the follwing dates'] = 'takip eden gnler iin:';
$strings['Start time must be less than end time'] = 'Balang zaman biti zamanndan nce olmaldr.';
$strings['Current start time is'] = 'Geerli balang zaman:';
$strings['Current end time is'] = 'Geerli biti zaman:';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'Rezervasyon sreniz kaynan izin verilen sresine uymuyor.';
$strings['Your reservation is'] = 'rezervasyonunuz:';
$strings['Minimum reservation length'] = 'En ksarezervasyon sresi:';
$strings['Maximum reservation length'] = 'En uzunrezervasyon sresi:';
$strings['You do not have permission to use this resource.'] = 'Bu kaynaa rezervasyon yetkiniz yok.';
$strings['reserved or unavailable'] = '%s den%s ekadar %s rezerve ya da uygun deil.';
$strings['Reservation created for'] = 'rezervasyon yaratld %s';
$strings['Reservation modified for'] = 'rezervasyon deitirildi %s';
$strings['Reservation deleted for'] = 'Rezervasyon silindi %s';
$strings['created'] = 'yaratld';
$strings['modified'] = 'deitirildi';
$strings['deleted'] = 'silindi';
$strings['Reservation #'] = 'Rezervasyon #';
$strings['Contact'] = 'letiim';
$strings['Reservation created'] = 'Rezervasyon yaratld';
$strings['Reservation modified'] = 'Rezervasyon deitirildi';
$strings['Reservation deleted'] = 'Rezervasyon silindi';

$strings['Reservations by month'] = 'Ay baznda rezervasyonlar';
$strings['Reservations by day of the week'] = 'Gn baznda rezervasyonlar';
$strings['Reservations per month'] = 'ay bana rezervasyonlar';
$strings['Reservations per user'] = 'Kullanc bana rezervasyonlar';
$strings['Reservations per resource'] = 'Kaynak bana rezervasyonlar';
$strings['Reservations per start time'] = 'Balang zaman bana rezervasyonlar';
$strings['Reservations per end time'] = 'Biti zaman bana rezervasyonlar';
$strings['[All Reservations]'] = '[Tm Rezervasyonlar]';

$strings['Permissions Updated'] = 'zinler gncellendi';
$strings['Your permissions have been updated'] = 'Sizin %s izinleriniz gncellendi';
$strings['You now do not have permission to use any resources.'] = 'Kaynak kullanm iin izniniz yok.';
$strings['You now have permission to use the following resources'] = 'Ekteki kaynaklara izniniz var:';
$strings['Please contact with any questions.'] = 'Sorularnz iin %s bavurunuz.';
$strings['Password Reset'] = 'ifre sfrla';

$strings['This will change your password to a new, randomly generated one.'] = 'Bu sizin ifreniz rasgele bir ifre ile deitirecektir.';
$strings['your new password will be set'] = 'eposta adresinizi girip ifre Deitire tklaynca yeni ifreniz size postalanacaktr.';
$strings['Change Password'] = 'ifre deitir';
$strings['Sorry, we could not find that user in the database.'] = 'Kullanc bulunamad.';
$strings['Your New Password'] = 'yeni %s ifreniz';
$strings['Your new passsword has been emailed to you.'] = 'baardnz!<br />yeni ifreniz size eposta olarak gnderildi.';
$strings['You are not logged in!'] = 'Giri yapmadnz!';

$strings['Setup'] = 'Kur';
$strings['Please log into your database'] = 'Veritabanna giri yapnz';
$strings['Enter database root username'] = 'veritaban root kullanc:';
$strings['Enter database root password'] = 'veritaban root ifre:';
$strings['Login to database'] = 'veritaban giri yap';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = 'Root kullanc <b></b> gerekmiyor. databse yaratma izni olan kullanc yeterli..';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'Veritaban ve tablolar kurulacak';
$strings['It also populates any required tables.'] = 'gerekli tablolar da yaratlacak.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Uyar: daha nceki rezervasyon veritabannz silinecektir';
$strings['Not a valid database type in the config.php file.'] = 'config.php geerli veritaban adn barndrmyor.';
$strings['Database user password is not set in the config.php file.'] = 'config.php veritaban kulalnc ifesi bulunmuyor.';
$strings['Database name not set in the config.php file.'] = 'config.php veritaban ad bulunmuyor.';
$strings['Successfully connected as'] = 'baland';
$strings['Create tables'] = 'Tablo yarat >';
$strings['There were errors during the install.'] = 'Kurulumda hatalar olutu.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'Kurulum baarl.';
$strings['Thank you for using phpScheduleIt'] = ' \'install\' Diznini siliniz.';
$strings['This will update your version of phpScheduleIt from 0.9.3 to 1.0.0.'] = 'upfate 0.9.3 to 1.0.0.';
$strings['There is no way to undo this action'] = 'Bu ilem geri alnamaz!';
$strings['Click to proceed'] = 'balamak iin tklaynz';
$strings['This version has already been upgraded to 1.0.0.'] = 'zaten versiyon 1.0';
$strings['Please delete this file.'] = 'Ltfen bu dosyay siliniz.';
$strings['Patch completed successfully'] = 'Yama baarl';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'Deer girilmezse konfig dosyasndaki ifre geerli';
$strings['Notify user that password has been changed?'] = 'Kullancy ifre deitii hakknda biilgilendir?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'Bu sistem eposta adresine sahip olmanz gerektirir.';
$strings['Invalid User Name/Password.'] = 'Geersiz kullanc ad/ifre.';
$strings['Pending User Reservations'] = 'Bekleyen kullanc rezervasyonlar';
$strings['Approve'] = 'Onayla';
$strings['Approve this reservation'] = 'Bu rezervasyonu onayla';
$strings['Approve Reservations'] ='Rezervasyonlar onayla';

$strings['Announcement'] = 'Duyuru';
$strings['Number'] = 'Numara';
$strings['Add Announcement'] = 'Duyuru ekle';
$strings['Edit Announcement'] = 'Duyuru dzenle';
$strings['All Announcements'] = 'Tm duyurular';
$strings['Delete Announcements'] = 'Duyurular sil';
$strings['Use start date/time?'] = 'Balang tarih/saat?';
$strings['Use end date/time?'] = 'Use end date/time?';
$strings['Announcement text is required.'] = 'Duyuru metni gerekli.';
$strings['Announcement number is required.'] = 'Duyuru numaras gerekli.';

$strings['Pending Approval'] = 'Onay bekliyor';
$strings['My reservation is approved'] = 'ezervasyonum onayland';
$strings['This reservation must be approved by the administrator.'] = 'Bu rezervasyon rezervasyon yneticisi tarafndan onaylanmaldr.';
$strings['Approval Required'] = 'Onay gerekli';
$strings['No reservations requiring approval'] = 'Onaylanmas gereken rezervasyon bulunmuyor';
$strings['Your reservation was successfully approved'] = 'Rezervasyonunuz onayland';
$strings['Reservation approved for'] = 'Rezervasyon onayland %s';
$strings['approved'] = 'onayland';
$strings['Reservation approved'] = 'Rezervasyon onayland';

$strings['Valid username is required'] = 'Geerli kullanc ad gerekli';
$strings['That logon name is taken already.'] = 'Bu kullanc ad zaten alnm.';
$strings['this will be your login'] = '(giri hesabnz olacak)';
$strings['Logon name'] = 'Giri ad';
$strings['Your logon name is'] = 'Giri adnz %s';

$strings['Start'] = 'Balang';
$strings['End'] = 'Biti';
$strings['Start date must be less than or equal to end date'] = 'Balang tarihi biti tarihinden nce olmaldr';
$strings['That starting date has already passed'] = 'Bu balang tarihi gemi';
$strings['Basic'] = 'Temel';
$strings['Participants'] = 'Katlmclar';
$strings['Close'] = 'Kapat';
$strings['Start Date'] = 'Balang tarihi';
$strings['End Date'] = 'Biti tarihi';
$strings['Minimum'] = 'En az';
$strings['Maximum'] = 'En ok';
$strings['Allow Multiple Day Reservations'] = 'oklu rezervasyona izin ver';
$strings['Invited Users'] = 'Davetli kullanclar';
$strings['Invite Users'] = 'Kullanclar davet et';
$strings['Remove Participants'] = 'Katlmclar kaldr';
$strings['Reservation Invitation'] = 'Rezervasyon Daveti';
$strings['Manage Invites'] = 'Davetlileri ynet';
$strings['No invite was selected'] = 'Davetli seilmedi';
$strings['reservation accepted'] = '%s Davetinizi kabul etti %s';
$strings['reservation declined'] = '%s Davetinizi reddetti %s';
$strings['Login to manage all of your invitiations'] = 'Tm davetlerinizi ynetmek iin giri yapnz';
$strings['Reservation Participation Change'] = 'Rezervasyon katlm deiiklii';
$strings['My Invitations'] = 'Davetlerim';
$strings['Accept'] = 'Kabul et';
$strings['Decline'] = 'Reddet';
$strings['Accept or decline this reservation'] = 'Bu rezervasyonu kabul ya da red edin';
$strings['My Reservation Participation'] = 'Rezervasyona katlmm';
$strings['End Participation'] = 'Katlm sonu';
$strings['Owner'] = 'Sahip';
$strings['Particpating Users'] = 'Katlmc kullanclar';
$strings['No advanced options available'] = 'Gelimi seenekler bulunmuyor';
$strings['Confirm reservation participation'] = 'Rezervasyon katlmn onayla';
$strings['Confirm'] = 'Onayla';
$strings['Do for all reservations in the group?'] = 'Bu gruptaki tm rezervasyonlar iin yap?';

$strings['My Calendar'] = 'Takvimim';
$strings['View My Calendar'] = 'Takvimimi gster';
$strings['Participant'] = 'Katlmc';
$strings['Recurring'] = 'Tekrarlayan';
$strings['Multiple Day'] = 'oklu gn';
$strings['[today]'] = '[bugn]';
$strings['Day View'] = 'Gn gster';
$strings['Week View'] = 'Hafta gster';
$strings['Month View'] = 'Ay gster';
$strings['Resource Calendar'] = 'Kaynak takvimi';
$strings['View Resource Calendar'] = 'izelge Takvimi';	// @since 1.2.0
$strings['Signup View'] = 'Kayt gster';

$strings['Select User'] = 'Kullanc se';
$strings['Change'] = 'Deitir';

$strings['Update'] = 'Gncelle';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'phpScheduleIt Gncellemesi sadece 1.0.0 ve sonras iin geerlidir';
$strings['phpScheduleIt is already up to date'] = 'phpScheduleIt zaten gncel';
$strings['Migrating reservations'] = 'Reservasyonlar tayor';

$strings['Admin'] = 'Ynetici';
$strings['Manage Announcements'] = 'Duyurular ynet';
$strings['There are no announcements'] = 'Duyuru Yok';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Azami Katlmc kapasitesi';
$strings['Leave blank for unlimited'] = 'Snrsz iin bo braknz';
$strings['Maximum of participants'] = 'Azami %s katlmc saysna ulat';
$strings['That reservation is at full capacity.'] = 'Bu rezervasyon kapasitesini doldurmutur.';
$strings['Allow registered users to join?'] = 'Kaytl kullanclar katlabilsin mi?';
$strings['Allow non-registered users to join?'] = 'Kaytsz kullanclar katlabilsin mi?';
$strings['Join'] = 'Katl';
$strings['My Participation Options'] = 'Katlmc Seeneklerim';
$strings['Join Reservation'] = 'Rezervasyona Katl';
$strings['Join All Recurring'] = 'Tm tekrarlayanlara katl';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'Aadaki rezervasyonlara kapasiteleri dolduundan katlamyorsunuz.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'Bu rezervasyona zaten davetlisiniz. Daha nce size eposta olarak gelen bilgileri takip ediniz.';
$strings['Additional Tools'] = 'Ek Aralar';
$strings['Create User'] = 'Kullanc Yarat';
$strings['Check Availability'] = 'Uygunluunu kontrol et';
$strings['Manage Additional Resources'] = 'Ek kaynaklar ynet';
$strings['All Additional Resources'] = 'Tm ek kaynaklar';
$strings['Number Available'] = 'Numara uygun';
$strings['Unlimited'] = 'Snrsz';
$strings['Add Additional Resource'] = 'Ek kaynak ekle';
$strings['Edit Additional Resource'] = 'Ek kaynak dzenle';
$strings['Checking'] = 'Kontol ediyor';
$strings['You did not select anything to delete.'] = 'Silmek iin bir ge semediniz.';
$strings['Added Resources'] = 'Eklenen Kaynaklar';
$strings['Additional resource is reserved'] = 'Ek kaynak %s larn %s bir seferde uygun';
$strings['All Groups'] = 'Tm Gruplar';
$strings['Group Name'] = 'Grup Ad';
$strings['Delete Groups'] = 'Gruplar Sil';
$strings['Manage Groups'] = 'Gruplar Ynet';
$strings['None'] = 'Hi';
$strings['Group name is required.'] = 'Grup ad gerekli.';
$strings['Groups'] = 'Gruplar';
$strings['Current Groups'] = 'Varolan Gruplar';
$strings['Group Administration'] = 'Grup Ynetimi';
$strings['Reminder Subject'] = 'Rezervasyon hatrlatc- %s, %s %s';
$strings['Reminder'] = 'Hatrlatc';
$strings['before reservation'] = 'rezervasyondan nce';
$strings['My Participation'] = 'Katlmm';
$strings['My Past Participation'] = 'Gemi katlmm';
$strings['Timezone'] = 'Zaman Aral';
$strings['Export'] = 'hra';
$strings['Select reservations to export'] = 'hra etmek iin rezervasyon se';
$strings['Export Format'] = 'hra biimi';
$strings['This resource cannot be reserved less than x hours in advance'] = 'Bu rezervasyon %s saatten az ayrtlamaz';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Bu rezervasyon %s saatten ok ayrtlamaz';
$strings['Minimum Booking Notice'] = 'En az ayrtma hatrlatmas';
$strings['Maximum Booking Notice'] = 'En ok ayrtma hatrlatmas';
$strings['hours prior to the start time'] = 'saat balang zamanndan nce';
$strings['hours from the current time'] = 'saat u andan itibaren';
$strings['Contains'] = 'erir';
$strings['Begins with'] = 'Balar';
$strings['Minimum booking notice is required.'] = 'En az ayrtma bilgisi gerekli.';
$strings['Maximum booking notice is required.'] = 'En ok ayrtma bilgisi gerekli.';
$strings['Accessory Name'] = 'Donat Ad';
$strings['Accessories'] = 'Donatlar';
$strings['All Accessories'] = 'Tm Donatlar';
$strings['Added Accessories'] = 'Eklenen donatlar';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n"
				. "Aadaki bilgi ile baaryla kayt oldunuz:\r\n"
				. "Giri: %s\r\n"
				. "Ad: %s %s \r\n"
				. "Telefon: %s \r\n"
				. "Blm: %s \r\n"
				. "Grev: %s \r\n\r\n"
				. "Rezervasyon iin:\r\n"
				. "%s \r\n\r\n"
				. "Profilinizi denetim masasndan gncelletirebilirsiniz.\r\n\r\n"
				. "Sorularnz iin %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Administrator,\r\n\r\n"
				. "Yeni kullanc kaydoldu\r\n"
				. "Eposta: %s \r\n"
				. "Ad: %s %s \r\n"
				. "Telefon: %s \r\n"
				. "Blm: %s \r\n"
				. "Grev: %s \r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n<br />"
			. "You have successfully %s reservation #%s.\r\n\r\n<br/><br/>"
			. "Please use this reservation number when contacting the administrator with any questions.\r\n\r\n<br/><br/>"
			. "A reservation between %s %s and %s %s for %s"
			. " located at %s has been %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "Bu rezervasyon aadaki tarihlerde tekrarlanacaktr:\r\n<br/>";
$email['reservation_activity_3'] = "Bu gruptaki tm tekrarlayan rezervasyonlarayn zamanda %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "rezervasyon zeti:\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "<br/><br/>rezervasyonunuzu istediiniz az deitirebilirsiniz %s :\r\n<br/><a href=&quot;%s&quot; target=&quot;_blank&quot;>%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "teknik sorular iin <a href=&quot;mailto:%s&quot;>%s</a>.\r\n\r\n<br/<br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n<br />"
			. "Reservasyon #%s onayland.\r\n\r\n<br/><br/>"
			. "Sorularnzda rezervasyon numaranz belirtiniz.\r\n\r\n<br/><br/>"
			. "Rezervasyon %s %s and %s %s for %s"
			. " yeri %s  %s.\r\n\r\n<br/><br/>";

// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Sizin%s ifreniz admin tarafndan sfrland.\r\n\r\nGeici ifreniz:\r\n\r\n %s\r\n";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\nyeni parolanz %s hesap:\r\n\r\n%s";

// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "%s sizi rezervasyonuna davet etti:\r\n\r\n"
		. "Kaynak: %s\r\n"
		. "Balang Tarihi: %s\r\n"
		. "Balang zaman: %s\r\n"
		. "Biti tarihi: %s\r\n"
		. "Biti zaman: %s\r\n"
		. "zet: %s\r\n"
		. "Tekrarlayan gnler (eer varsa): %s\r\n\r\n"
		. "Daveti kabul etmek iin bu kprye tklaynz (iaretlenmemise kopyala yaptr yapabilirsiniz) %s\r\n"
		. "Daveti red etmek iin (iaretlenmemise kopyala yaptr yapabilirsiniz) %s\r\n"
		. "Seim gnlerini kabul etmek ya da rezervasyonlarnz ynetmek iin, giri yapnz %s at %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Aadaki rezervasyondan kaldrldnz:\r\n\r\n"
		. "Kaynak: %s\r\n"
		. "Balang tarihi: %s\r\n"
		. "Balang zaman: %s\r\n"
		. "Biti tarihi: %s\r\n"
		. "Biti zaman: %s\r\n"
		. "zet: %s\r\n"
		. "Tekrarlanan tarihler (eer varsa): %s\r\n\r\n";	

// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "Rezervasyonunuz %s  %s den %s a %s %s yaklayor.";
?>