<?php
/**
* Spanish (es) translation file.
*  
* @author Nick Korbel <lqqkout13@users.sourceforge.net>
* @translator Josue Rojas <josue_rojas@hotmail.com>
* @version 14-05-06
* @revisin parcial: Manuel Gualda Caballero <manuel@utopiaverde.org> (13-10-08)
* @package Languages
*
* Copyright (C) 2003 - 2008 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
// Please save the translated file as '2 letter language code'.lang.php.  For example, en.lang.php.
// 
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  If there
//  is no direct translation, please provide the closest translation.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//  Also, please add a help translation for your language using en.help.php as a base.
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'iso-8859-1';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element 
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('Domingo', 'Lunes', 'Martes', 'Mircoles', 'Jueves', 'Viernes', 'Sbado');
// The three letter abbreviation
$days_abbr = array('Dom', 'Lun', 'Mar', 'Mi', 'Jue', 'Vie', 'Sb');
// The two letter abbreviation
$days_two  = array('Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'S');
// The one letter abbreviation
$days_letter = array('D', 'L', 'M', 'M', 'J', 'V', 'S');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
// The three letter month name
$months_abbr = array('Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%d/%m/%Y';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%d/%m/%Y @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%A %d/%m/%Y';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%A,<br/>%d/%m/%Y';
// Date on top-right of each page
$dates['header'] = '%A, %d %B, %Y';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box 
$dates['jumpbox'] = '%d %m %Y';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'horas';
$strings['minutes'] = 'minutos';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'mm';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'dd';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = 'aaaa';
$strings['am'] = 'am';
$strings['pm'] = 'pm';

$strings['Administrator'] = 'Administrador';
$strings['Welcome Back'] = 'Hola %s';
$strings['Log Out'] = 'Cerrar sesin';
$strings['My Control Panel'] = 'Mi panel de control';
$strings['Help'] = 'Ayuda';
$strings['Manage Schedules'] = 'Horarios';
$strings['Manage Users'] ='Usuarios';
$strings['Manage Resources'] ='Recursos';
$strings['Manage User Training'] ='Entrenamiento de usuarios';
$strings['Manage Reservations'] ='Reservas';
$strings['Email Users'] ='Correo eletrnico a usuarios';
$strings['Export Database Data'] = 'Exportar base de datos';
$strings['Reset Password'] = 'Establecer contrasea';
$strings['System Administration'] = 'Administracin';
$strings['Successful update'] = 'Actualizacin correcta';
$strings['Update failed!'] = 'Fallo la actualizacin!';
$strings['Manage Blackout Times'] = 'Tiempos muertos';
$strings['Forgot Password'] = 'Olvid su contrasea';
$strings['Manage My Email Contacts'] = 'Mis contactos de correo';
$strings['Choose Date'] = 'Escoja la fecha';
$strings['Modify My Profile'] = 'Modificar mi perfil';
$strings['Register'] = 'Registro';
$strings['Processing Blackout'] = 'Procesando tiempo muerto';
$strings['Processing Reservation'] = 'Procesando reserva';
$strings['Online Scheduler [Read-only Mode]'] = 'Horario en lnea [modo de slo consulta]';
$strings['Online Scheduler'] = 'Horario en lnea';
$strings['phpScheduleIt Statistics'] = 'Estadsticas del sistema';
$strings['User Info'] = 'Datos del usuario:';

$strings['Could not determine tool'] = 'No se puede determinar la herramienta. Por favor vuelva a Mi panel de control e intente de nuevo ms tarde.';
$strings['This is only accessable to the administrator'] = 'Esto slo est disponible para el administrador';
$strings['Back to My Control Panel'] = 'Volver a Mi panel de control';
$strings['That schedule is not available.'] = 'Ese horario no est disponible.';
$strings['You did not select any schedules to delete.'] = 'Usted no ha seleccionado horarios para borrar.';
$strings['You did not select any members to delete.'] = 'Usted no ha seleccionado miembros para borrar.';
$strings['You did not select any resources to delete.'] = 'Usted no ha seleccionado recursos para borrar.';
$strings['Schedule title is required.'] = 'Es necesario un nombre para el horario.';
$strings['Invalid start/end times'] = 'Las horas de inicio o fin no son vlidas.';
$strings['View days is required'] = 'Es necesario el nmero de das visibles';
$strings['Day offset is required'] = 'Es necesario indicar el primer da de la semana';
$strings['Admin email is required'] = 'Es necesario el correo administrativo';
$strings['Resource name is required.'] = 'Es necesario un nombre para el recurso.';
$strings['Valid schedule must be selected'] = 'Debe seleccionar un horario vlido';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'La duracin mnima de la reserva debe se menor o igual que la duracin mxima de la reserva.';
$strings['Your request was processed successfully.'] = 'Su solicitud fue procesada correctamente.';
$strings['Go back to system administration'] = 'Vuelva a la administracin del sistema';
$strings['Or wait to be automatically redirected there.'] = 'o espere para ser dirigido automticamente.';
$strings['There were problems processing your request.'] = 'Se presentaron inconvenientes procesando su solicitud.';
$strings['Please go back and correct any errors.'] = 'Por favor vuelva atrs y corrija los errores que existan.';
$strings['Login to view details and place reservations'] = 'Inicie sesin para ver los detalles y hacer reservas';
$strings['Memberid is not available.'] = 'El id de usuario: %s no est disponible.';

$strings['Schedule Title'] = 'Nombre del horario';
$strings['Start Time'] = 'Hora inicio';
$strings['End Time'] = 'Hora fin';
$strings['Time Span'] = 'Franjas de tiempo';
$strings['Weekday Start'] = 'Primer da de la semana';
$strings['Admin Email'] = 'Correo administrativo';

$strings['Default'] = 'Predeterminado';
$strings['Reset'] = 'Restablecer';
$strings['Edit'] = 'Editar';
$strings['Delete'] = 'Borrar';
$strings['Cancel'] = 'Cancelar';
$strings['View'] = 'Verificar';
$strings['Modify'] = 'Modificar';
$strings['Save'] = 'Guardar';
$strings['Back'] = 'Volver';
$strings['Next'] = 'Siguiente';
$strings['Close Window'] = 'Cerrar ventana';
$strings['Search'] = 'Buscar';
$strings['Clear'] = 'Limpiar';

$strings['Days to Show'] = 'Das visibles';
$strings['Reservation Offset'] = 'Espacio entre reservas';
$strings['Hidden'] = 'Oculto';
$strings['Show Summary'] = 'Mostrar descripcin';
$strings['Add Schedule'] = 'Aadir horario';
$strings['Edit Schedule'] = 'Cambiar horario';
$strings['No'] = 'No';
$strings['Yes'] = 'Si';
$strings['Name'] = 'Nombre';
$strings['First Name'] = 'Nombres';
$strings['Last Name'] = 'Apellidos';
$strings['Resource Name'] = 'Nombre del recurso';
$strings['Email'] = 'Correo electrnico';
$strings['Institution'] = 'Institucin';
$strings['Phone'] = 'Telfono';
$strings['Password'] = 'Contrasea';
$strings['Permissions'] = 'Permisos';
$strings['View information about'] = 'Ver la informacin de %s %s';
$strings['Send email to'] = 'Enviar correo a %s %s';
$strings['Reset password for'] = 'Restablecer la contrasea para %s %s';
$strings['Edit permissions for'] = 'Editar permisos para %s %s';
$strings['Position'] = 'Cargo';
$strings['Password (6 char min)'] = 'Contrasea (%s letras min.)';
$strings['Re-Enter Password'] = 'Confirme la contrasea';

$strings['Sort by descending last name'] = 'Ordenar por apellido en forma descendente';
$strings['Sort by descending email address'] = 'Ordenar por correo en forma descendente';
$strings['Sort by descending institution'] = 'Ordenar por institucin en forma descendente';
$strings['Sort by ascending last name'] = 'Ordenar por apellido en forma ascendente';
$strings['Sort by ascending email address'] = 'Ordenar por correo en forma ascendente';
$strings['Sort by ascending institution'] = 'Ordenar por institucin en forma ascendente';
$strings['Sort by descending resource name'] = 'Ordenar por nombre del recurso en forma descendente';
$strings['Sort by descending location'] = 'Ordenar por ubicacin en forma descendente';
$strings['Sort by descending schedule title'] = 'Ordenar por nombre del horario en forma descendente';
$strings['Sort by ascending resource name'] = 'Ordenar por nombre del recurso en forma ascendente';
$strings['Sort by ascending location'] = 'Ordenar por ubicacin en forma ascendente';
$strings['Sort by ascending schedule title'] = 'Ordenar por nombre del horario en forma ascendente';
$strings['Sort by descending date'] = 'Ordenar por fecha en forma descendente';
$strings['Sort by descending user name'] = 'Ordenar por nombre de usuario en forma descendente';
$strings['Sort by descending start time'] = 'Ordenar por fecha inicial en forma descendente';
$strings['Sort by descending end time'] = 'Ordenar por fecha final en forma descendente';
$strings['Sort by ascending date'] = 'Ordenar por fecha en forma ascendente';
$strings['Sort by ascending user name'] = 'Ordenar por nombre de usuario en forma ascendente';
$strings['Sort by ascending start time'] = 'Ordenar por fecha inicial en forma ascendente';
$strings['Sort by ascending end time'] = 'Ordenar por fecha final en forma descendente';
$strings['Sort by descending created time'] = 'Ordenar por fecha de solicitud en forma ascendente';
$strings['Sort by ascending created time'] = 'Ordenar por fecha de solicitud en forma descendente';
$strings['Sort by descending last modified time'] = 'Ordenar por fecha de modificacin en forma ascendente';
$strings['Sort by ascending last modified time'] = 'Ordenar por fecha de modificacin en forma descendente';

$strings['Search Users'] = 'Buscar usuarios';
$strings['Location'] = 'Ubicacin';
$strings['Schedule'] = 'Horario';
$strings['Phone'] = 'Telfono';
$strings['Notes'] = 'Notas';
$strings['Status'] = 'Estado';
$strings['All Schedules'] = 'Todos los horarios';
$strings['All Resources'] = 'Todos los recursos';
$strings['All Users'] = 'Todos los usuarios';

$strings['Edit data for'] = 'Editar la informacin de %s';
$strings['Active'] = 'Activo';
$strings['Inactive'] = 'Inactivo';
$strings['Toggle this resource active/inactive'] = 'Cambiar este recuso entre activo/inactivo';
$strings['Minimum Reservation Time'] = 'Tiempo mnimo de reserva';
$strings['Maximum Reservation Time'] = 'Tiempo mximo de reserva';
$strings['Auto-assign permission'] = 'Permiso de auto-asignacin';
$strings['Add Resource'] = 'Aadir recurso';
$strings['Edit Resource'] = 'Editar recurso';
$strings['Allowed'] = 'Permitido';
$strings['Notify user'] = 'Notificar al usuario';
$strings['User Reservations'] = 'Reservas de usuario';
$strings['Date'] = 'Fecha';
$strings['User'] = 'Usuario';
$strings['Email Users'] = 'Enviar un correo a los usuarios';
$strings['Subject'] = 'Asunto';
$strings['Message'] = 'Mensaje';
$strings['Please select users'] = 'Por favor seleccione los usuarios';
$strings['Send Email'] = 'Enviar correo';
$strings['problem sending email'] = 'Lo siento, hubo un problema enviando el correo. Por favor intente ms tarde.';
$strings['The email sent successfully.'] = 'El correo fue enviado correctamente.';
$strings['do not refresh page'] = 'Por favor <u>NO</u> use actualizar en esta pgina. Si lo hace, el correo se enviar otra vez.';
$strings['Return to email management'] = 'Volver a administracin de correo';
$strings['Please select which tables and fields to export'] = 'Por favor indique qu tablas y campos desea exportar:';
$strings['all fields'] = '- todos los campos -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Texto simple';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'Exportar datos';
$strings['Reset Password for'] = 'Restablecer contrasea de %s';
$strings['Please edit your profile'] = 'Por favor modifique su perfil';
$strings['Please register'] = 'Por favor regstrese';
$strings['Email address (this will be your login)'] = 'Direccin de correo (este ser su nombre de usuario)';
$strings['Keep me logged in'] = 'Mantener la sesin abierta:';
$strings['Edit Profile'] = 'Editar perfil';
$strings['Register'] = 'Registrarse';
$strings['Please Log In'] = 'Por favor inicie sesin';
$strings['Email address'] = 'Direccin de correo';
$strings['Password'] = 'Contrasea:';
$strings['First time user'] = 'Usuario por primera vez?';
$strings['Click here to register'] = 'Regstrese haciendo clic aqu';
$strings['Register for phpScheduleIt'] = 'Registrarse en phpScheduleIt';
$strings['Log In'] = 'Iniciar sesin';
$strings['View Schedule'] = 'Ver horario';
$strings['View a read-only version of the schedule'] = 'Ver una versin de solo lectura del horario';
$strings['I Forgot My Password'] = 'Olvid mi contrasea';
$strings['Retreive lost password'] = 'Recuperar contrasea perdida';
$strings['Get online help'] = 'Obtener ayuda en lnea';
$strings['Language'] = 'Idioma:';
$strings['(Default)'] = '(predeterminado)';

$strings['My Announcements'] = 'Mis anuncios';
$strings['My Reservations'] = 'Mis reservas';
$strings['My Permissions'] = 'Mis permisos';
$strings['My Quick Links'] = 'Mis accesos directos';
$strings['Announcements as of'] = 'Anuncios para el %s';
$strings['There are no announcements.'] = 'No existen anuncios.';
$strings['Resource'] = 'Recurso';
$strings['Created'] = 'Creado';
$strings['Last Modified'] = 'Modificado por ltima vez';
$strings['View this reservation'] = 'Ver esta reserva';
$strings['Modify this reservation'] = 'Modificar esta reserva';
$strings['Delete this reservation'] = 'Borrar esta reserva';
$strings['Bookings'] = 'Reservas';
$strings['Change My Profile Information/Password'] = 'Cambiar perfil';		// @since 1.2.0
$strings['Manage My Email Preferences'] = 'Preferencias de correo';				// @since 1.2.0
$strings['Mass Email Users'] = 'Correo masivo';
$strings['Search Scheduled Resource Usage'] = 'Buscar reservas';		// @since 1.2.0
$strings['Export Database Content'] = 'Exportar datos';
$strings['View System Stats'] = 'Estadsticas';
$strings['Email Administrator'] = 'Enviar un correo al administrador';

$strings['Email me when'] = 'Enviarme un correo cuando:';
$strings['I place a reservation'] = 'Yo haga una reserva';
$strings['My reservation is modified'] = 'Se modifique mi reserva';
$strings['My reservation is deleted'] = 'Se borre mi reserva';
$strings['I prefer'] = 'Prefiero:';
$strings['Your email preferences were successfully saved'] = 'Sus preferencias de correo han sido guardadas';
$strings['Return to My Control Panel'] = 'Volver a Mi panel de control';

$strings['Please select the starting and ending times'] = 'Por favor indique las fechas inicial y final';
$strings['Please change the starting and ending times'] = 'Por favor cambie las fechas inicial y final';
$strings['Reserved time'] = 'Tiempo reservado:';
$strings['Minimum Reservation Length'] = 'Tiempo mnimo de reserva:';
$strings['Maximum Reservation Length'] = 'Tiempo mximo de reserva:';
$strings['Reserved for'] = 'Reservado para:';
$strings['Will be reserved for'] = 'Ser reservado para:';
$strings['N/A'] = 'N/D';
$strings['Update all recurring records in group'] = 'Actualizar todos los registros recurrentes a la vez?';
$strings['Delete?'] = 'Borrar?';
$strings['Never'] = '-- Nunca --';
$strings['Days'] = 'Das';
$strings['Weeks'] = 'Semanas';
$strings['Months (date)'] = 'Meses (fecha)';
$strings['Months (day)'] = 'Meses (da)';
$strings['First Days'] = 'Primer da';
$strings['Second Days'] = 'Segundo da';
$strings['Third Days'] = 'Tercer da';
$strings['Fourth Days'] = 'Cuarto da';
$strings['Last Days'] = 'ltimo da';
$strings['Repeat every'] = 'Repetir cada:';
$strings['Repeat on'] = 'Repetir en:';
$strings['Repeat until date'] = 'Repetir hasta esta fecha:';
$strings['Choose Date'] = 'Elegir fecha';
$strings['Summary'] = 'Descripcin (tipo de evento)';

$strings['View schedule'] = 'Ver horario:';
$strings['My Reservations'] = 'Mis reservas';
$strings['My Past Reservations'] = 'Mis reservas pasadas';
$strings['Other Reservations'] = 'Otras reservas';
$strings['Other Past Reservations'] = 'Otras reservas pasadas';
$strings['Blacked Out Time'] = 'Tiempo muerto';
$strings['Set blackout times'] = 'Establecer tiempo muerto para %s en %s'; 
$strings['Reserve on'] = 'Reservar %s en %s';
$strings['Prev Week'] = ' Semana anterior';
$strings['Jump 1 week back'] = 'Volver 1 semana atrs';
$strings['Prev days'] = ' %d das ant.';
$strings['Previous days'] = ' %d das anteriores';
$strings['This Week'] = 'Esta semana';
$strings['Jump to this week'] = 'Ir a esta semana';
$strings['Next days'] = '%d das siguientes ';
$strings['Next Week'] = 'Siguiente semana ';
$strings['Jump To Date'] = 'Ir a una fecha';
$strings['View Monthly Calendar'] = 'Ver calendario mensual';
$strings['Open up a navigational calendar'] = 'Abrir un calendario para navegar';

$strings['View stats for schedule'] = 'Ver estadsticas del horario:';
$strings['At A Glance'] = 'Un vistazo';
$strings['Total Users'] = 'Total de usuarios:';
$strings['Total Resources'] = 'Total de recursos:';
$strings['Total Reservations'] = 'Total de reservas:';
$strings['Max Reservation'] = 'Reserva mxima:';
$strings['Min Reservation'] = 'Reserva mnima:';
$strings['Avg Reservation'] = 'Reserva promedio:';
$strings['Most Active Resource'] = 'Recurso ms activo:';
$strings['Most Active User'] = 'Usuario ms activo:';
$strings['System Stats'] = 'Estadsticas del sistema';
$strings['phpScheduleIt version'] = 'Versin de phpScheduleIt:';
$strings['Database backend'] = 'Base de datos:';
$strings['Database name'] = 'Nombre de base de datos:';
$strings['PHP version'] = 'Versin de PHP:';
$strings['Server OS'] = 'Sistema del servidor:';
$strings['Server name'] = 'Nombre del servidor:';
$strings['phpScheduleIt root directory'] = 'Directorio raz de phpScheduleIt:';
$strings['Using permissions'] = 'Permisos de uso:';
$strings['Using logging'] = 'Log de uso:';
$strings['Log file'] = 'Archivo bitcora:';
$strings['Admin email address'] = 'Direccin correo del administrador:';
$strings['Tech email address'] = 'Direccin correo tcnico:';
$strings['CC email addresses'] = 'Direcciones correo para copias (CC):';
$strings['Reservation start time'] = 'Hora inicial de reserva:';
$strings['Reservation end time'] = 'Hora final de reserva:';
$strings['Days shown at a time'] = 'Das mostrados a la vez:';
$strings['Reservations'] = 'Reservas';
$strings['Return to top'] = 'Volver arriba';
$strings['for'] = 'para';

$strings['Select Search Criteria'] = 'Indique los criterios de bsqueda';
$strings['Schedules'] = 'Horarios:';
$strings['All Schedules'] = 'Todos los horarios';
$strings['Hold CTRL to select multiple'] = 'Mantenga la tecla CTRL presionada para seleccionar varios';
$strings['Users'] = 'Usuarios:';
$strings['All Users'] = 'Todos los usuarios';
$strings['Resources'] = 'Recursos';
$strings['All Resources'] = 'Todos los recursos:';
$strings['Starting Date'] = 'Fecha inicial:';
$strings['Ending Date'] = 'Fechas final:';
$strings['Starting Time'] = 'Hora inicial:';
$strings['Ending Time'] = 'Hora final:';
$strings['Output Type'] = 'Tipo de salida:';
$strings['Manage'] = 'Administrar';
$strings['Total Time'] = 'Tiempo total';
$strings['Total hours'] = 'Horas en total:';
$strings['% of total resource time'] = '% del tiempo total del recurso';
$strings['View these results as'] = 'Ver estos resultados como:';
$strings['Edit this reservation'] = 'Editar esta reserva';
$strings['Search Results'] = 'Buscar resultados';
$strings['Search Resource Usage'] = 'Buscar utilizacin del recurso';
$strings['Search Results found'] = 'Resultados de la bsqueda: Se encontraron %d reservas';
$strings['Try a different search'] = 'Intente otra bsqueda';
$strings['Search Run On'] = 'Hacer la bsqueda en:';
$strings['Member ID'] = 'ID de miembro';
$strings['Previous User'] = ' Usuario anterior';
$strings['Next User'] = 'Usuario siguiente ';

$strings['No results'] = 'No hay resultados';
$strings['That record could not be found.'] = 'No se encontr ese registro.';
$strings['This blackout is not recurring.'] = 'Este tiempo muerto no es recurrente.';
$strings['This reservation is not recurring.'] = 'Esta reserva no es recurrente.';
$strings['There are no records in the table.'] = 'No hay registros en la tabla %s.';
$strings['You do not have any reservations scheduled.'] = 'No tiene ninguna reserva programada.';
$strings['You do not have permission to use any resources.'] = 'No tiene permiso para usar ningn recurso.';
$strings['No resources in the database.'] = 'No hay recursos en la base de datos.';
$strings['There was an error executing your query'] = 'Hubo un error ejecutando el comando en la base de datos:';

$strings['That cookie seems to be invalid'] = 'Esa cookie parece ser invlida';
$strings['We could not find that email in our database.'] = 'No se encontr ese correo en la base de datos.';
$strings['That password did not match the one in our database.'] = 'Esa contrasea no coincide con la de nuestra base de datos.';
$strings['You can try'] = 'Usted puede';
$strings['A new user has been added'] = 'Un nuevo usuario ha sido aadido';
$strings['You have successfully registered'] = 'Usted se ha registrado correctamente!';
$strings['Continue'] = 'Continuar';
$strings['Your profile has been successfully updated!'] = 'Su perfil ha sido actualizado correctamente!';
$strings['Please return to My Control Panel'] = 'Por favor vuelva a Mi panel de control';
$strings['Valid email address is required.'] = 'Se requiere una direccin de correo vlida.';
$strings['First name f.'] = 'Se requiere el nombre.';
$strings['Last name is required.'] = 'Se requiere el apellido.';
$strings['Phone number is required.'] = 'Se requiere el nmero de telfono.';
$strings['That email is taken already.'] = 'Ese correo ya est registrado.';
$strings['Min 6 character password is required.'] = 'La contrasea debe tener un mnimo de %s caracteres.';
$strings['Passwords do not match.'] = 'Las contraseas no coinciden.';

$strings['Per page'] = 'Por pgina:';
$strings['Page'] = 'Pgina:';

$strings['Your reservation was successfully created'] = 'Su reserva fue creada correctamente';
$strings['Your reservation was successfully modified'] = 'Su reserva fue modificada correctamente';
$strings['Your reservation was successfully deleted'] = 'Su reserva fue borrada correctamente';
$strings['Your blackout was successfully created'] = 'Su tiempo muerto fue creado correctamente';
$strings['Your blackout was successfully modified'] = 'Su tiempo muerto fue modificado correctamente';
$strings['Your blackout was successfully deleted'] = 'Su tiempo muerto fue borrado correctamente';
$strings['for the follwing dates'] = 'para las siguientes fechas:';
$strings['Start time must be less than end time'] = 'El momento inicial debe ser anterior al momento final.';
$strings['Reservation Not Available'] = 'Reserva no disponible';
$strings['Reservation Available'] = 'Reserva disponible';
$strings['Current start time is'] = 'Fecha inicial actualmente es:';
$strings['Current end time is'] = 'Fecha final actualmente es:';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'La duracin de la reserva no est en el rango permitido para este recurso.';
$strings['Your reservation is'] = 'Su reserva es:';
$strings['Minimum reservation length'] = 'Duracin mnima de la reserva:';
$strings['Maximum reservation length'] = 'Duracin mxima de la reserva:';
$strings['You do not have permission to use this resource.'] = 'Usted no tiene permiso para usar este recurso.';
$strings['reserved or unavailable'] = '%s hasta %s ya est reservado o no est disponible.';	// @since 1.1.0
$strings['Reservation created for'] = 'Reserva creada para %s';
$strings['Reservation modified for'] = 'Reserva modificada para %s';
$strings['Reservation deleted for'] = 'Reserva borrada para %s';
$strings['created'] = 'creado';
$strings['modified'] = 'modificado';
$strings['deleted'] = 'borrado';
$strings['Reservation #'] = 'Reserva #';
$strings['Contact'] = 'Contacto';
$strings['Reservation created'] = 'Reserva creada';
$strings['Reservation modified'] = 'Reserva modificada';
$strings['Reservation deleted'] = 'Reserva borrada';

$strings['Reservations by month'] = 'Reservas por mes';
$strings['Reservations by day of the week'] = 'Reservas por da de la semana';
$strings['Reservations per month'] = 'Reservas por mes';
$strings['Reservations per user'] = 'Reservas por usuario';
$strings['Reservations per resource'] = 'Reservas por recurso';
$strings['Reservations per start time'] = 'Reservas por fecha inicial';
$strings['Reservations per end time'] = 'Reservas por fecha final';
$strings['[All Reservations]'] = '[Todas las reservas]';

$strings['Permissions Updated'] = 'Permisos actualizados';
$strings['Your permissions have been updated'] = 'Sus %s permisos han sido actualizados';
$strings['You now do not have permission to use any resources.'] = 'Usted no tiene permisos para usar ningn recurso.';
$strings['You now have permission to use the following resources'] = 'Usted no tiene permisos para usar los siguientes recursos:';
$strings['Please contact with any questions.'] = 'Por favor contacte a %s para ms informacin.';
$strings['Password Reset'] = 'Contrasea restablecida';

$strings['This will change your password to a new, randomly generated one.'] = 'Esto cambiar su contrasea a una nueva, generada aleatoriamente.';
$strings['your new password will be set'] = 'Despus de escribir su correo y hacer clic en cambiar contrasea, su nueva contrasea ser activada en el sistema y enviada a su correo.';
$strings['Change Password'] = 'Cambiar contrasea';
$strings['Sorry, we could not find that user in the database.'] = 'Lo siento, el usuario no se encuentra en la base de datos.';
$strings['Your New Password'] = 'Su nueva %s contrasea';
$strings['Your new passsword has been emailed to you.'] = 'Su nueva contrasea ha sido enviada.';

$strings['You are not logged in!'] = 'Usted no ha iniciado sesin!';

$strings['Setup'] = 'Configuracin';
$strings['Please log into your database'] = 'Por favor inicie sesin en la base de datos';
$strings['Enter database root username'] = 'Indique el usuario root de la base de datos:';
$strings['Enter database root password'] = 'Indique la contrasea de root:';
$strings['Login to database'] = 'Iniciar sesin en la base de datos';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = '<b>No</b> es necesario el usuario root. Cualquier usuario con permisos para crear tablas funciona.';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'Esto crear las bases de datos y tablas necesarias para phpScheduleIt.';
$strings['It also populates any required tables.'] = 'Tambin crear los datos en las tablas requeridas.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Advertencia: ESTO BORRAR TODA LA INFORMACIN DE BASES DE DATOS ANTERIORES DE phpScheduleIt!';
$strings['Not a valid database type in the config.php file.'] = 'Tipo invlido de base de datos en el archivo config.php.';
$strings['Database user password is not set in the config.php file.'] = 'Password de usuario de base de datos no indicada en el archivo config.php.';
$strings['Database name not set in the config.php file.'] = 'Nombre de base de datos no indicado en el archivo config.php.';
$strings['Successfully connected as'] = 'Se conect correctamente como';
$strings['Create tables'] = 'Crear tablas &gt;';
$strings['There were errors during the install.'] = 'Hubo errores durante la instalacin. Es posible, sin embargo, que phpScheduleIt funcione si los problemas no fueron graves.<br/><br/>'
	. 'Por favor publique sus preguntas en los foros de <a href="http://sourceforge.net/forum/?group_id=95547">SourceForge</a>.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'Usted ha terminado de instalar phpScheduleIt y est listo para empezar a usarlo.';
$strings['Thank you for using phpScheduleIt'] = 'Por favor ELIMINE COMPLETAMENTE EL DIRECTORIO \'install\'.'
	. ' Esto es crtico ya que contiene las contraseas de la base de datos y otra informacin importante.'
	. ' El no hacerlo es dejar la puerta abierta para que cualquier persona tome el control de su sistema!'
	. '<br /><br />'
	. 'Gracias por usar phpScheduleIt!';
$strings['This will update your version of phpScheduleIt from 0.9.3 to 1.0.0.'] = 'Esto actualizar su versin de phpScheduleIt de 0.9.3 a 1.0.0.';
$strings['There is no way to undo this action'] = 'No hay forma de deshacer este cambio!';
$strings['Click to proceed'] = 'Clic para iniciar';
$strings['This version has already been upgraded to 1.0.0.'] = 'Esta versin ya fue actualizada a 1.0.0.';
$strings['Please delete this file.'] = 'Por favor borre este archivo.';
$strings['Successful update'] = 'La actualizacin se hizo correctamente';
$strings['Patch completed successfully'] = 'La correccin se completo correctamente';
$strings['This will populate the required fields for phpScheduleIt 1.0.0 and patch a data bug in 0.9.9.'] = 'Esto llenar los campos requeridos para phpScheduleIt 1.0.0 y corregir el error de datos de 0.9.9.'
		. '<br />Slo se requiere ejecutar esto si Usted realiz una actualizacin manual de SQL o est actualizando versin desde 0.9.9';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'Si no se especific un valor, se usar la contrasea por defecto del archivo de configuracin.';
$strings['Notify user that password has been changed?'] = 'Notificar al usuario que la contrasea ha cambiado?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'Este sistema requiere que Usted tenga una direccin de correo.';
$strings['Invalid User Name/Password.'] = 'Nombre de usuario/contrasea Invlido.';
$strings['Pending User Reservations'] = 'Reservas de usuario pendientes';
$strings['Approve'] = 'Aprobar';
$strings['Approve this reservation'] = 'Aprobar esta reserva';
$strings['Approve Reservations'] ='Aprobar reservas';

$strings['Announcement'] = 'Anuncio';
$strings['Number'] = 'Nmero';
$strings['Add Announcement'] = 'Aadir anuncio';
$strings['Edit Announcement'] = 'Editar anuncio';
$strings['All Announcements'] = 'Todos los anuncios';
$strings['Delete Announcements'] = 'Borrar anuncios';
$strings['Use start date/time?'] = 'Usar fecha/hora de inicio?';
$strings['Use end date/time?'] = 'Usar fecha/hora de finalizacin?';
$strings['Announcement text is required.'] = 'Se requiere un texto para el anuncio.';
$strings['Announcement number is required.'] = 'Se requiere un nmero para el anuncio.';

$strings['Pending Approval'] = 'Aprobacin pendiente';
$strings['My reservation is approved'] = 'Mi reserva est aprobada';
$strings['This reservation must be approved by the administrator.'] = 'Esta reserva debe ser aprobada por el administrador.';
$strings['Approval Required'] = 'Se requiere aprobacin';
$strings['No reservations requiring approval'] = 'No hay reservas que necesiten ser aprobadas';
$strings['Your reservation was successfully approved'] = 'Su reserva fue aprobada correctamente';
$strings['Reservation approved for'] = 'Reserva aprobada para %s';
$strings['approved'] = 'aprobada';
$strings['Reservation approved'] = 'Reserva aprobada';

$strings['Valid username is required'] = 'Se requiere una nombre de usuario vlido';
$strings['That logon name is taken already.'] = 'Ese nombre de usuario ya est siendo utilizado.';
$strings['this will be your login'] = 'este ser su nombre de usuario';
$strings['Logon name'] = 'Nombre de usuario:';
$strings['Your logon name is'] = 'Su nombre de usuario es %s';

$strings['Start'] = 'Inicio';
$strings['End'] = 'Fin';
$strings['Start date must be less than or equal to end date'] = 'La fecha de inicio debe ser menor o igual que la fecha de finalizacin';
$strings['That starting date has already passed'] = 'Esa fecha de inici ya pas';
$strings['Basic'] = 'Bsico';
$strings['Participants'] = 'Participantes';
$strings['Close'] = 'Cierre';
$strings['Start Date'] = 'Fecha inicial';
$strings['End Date'] = 'Fecha final';
$strings['Minimum'] = 'Mnimo';
$strings['Maximum'] = 'Mximo';
$strings['Allow Multiple Day Reservations'] = 'Permitir reservas de mltiples das';
$strings['Invited Users'] = 'Usuarios invitados';
$strings['Invite Users'] = 'Invitar usuarios';
$strings['Remove Participants'] = 'Eliminar participantes';
$strings['Reservation Invitation'] = 'Reserva invitacin';
$strings['Manage Invites'] = 'Administrar invitados';
$strings['No invite was selected'] = 'No fue seleccionado algn invitado';
$strings['reservation accepted'] = '%s Acept su invitacin el %s';
$strings['reservation declined'] = '%s Rechaz su invitacin el %s';
$strings['Login to manage all of your invitiations'] = 'Ingrese para administrar todas sus invitaciones';
$strings['Reservation Participation Change'] = 'Cambio de la participacin en la reserva';
$strings['My Invitations'] = 'Mis invitaciones';
$strings['Accept'] = 'Aceptar';
$strings['Decline'] = 'Rechazar';
$strings['Accept or decline this reservation'] = 'Aceptar o rechazar esta reserva';
$strings['My Reservation Participation'] = 'Mi participacin en la reserva';
$strings['End Participation'] = 'Terminar participacin';
$strings['Owner'] = 'Propietario';
$strings['Particpating Users'] = 'Usuarios participantes';
$strings['No advanced options available'] = 'No hay opciones avanzadas disponibles';
$strings['Confirm reservation participation'] = 'Confirmar participacin en la reserva';
$strings['Confirm'] = 'Confirmar';
$strings['Do for all reservations in the group?'] = 'Hacerlo para todas las reservas en el grupo?';

$strings['My Calendar'] = 'Mi calendario';
$strings['View My Calendar'] = 'Ver mi calendario';
$strings['Participant'] = 'Participante';
$strings['Recurring'] = 'Recurrente';
$strings['Multiple Day'] = 'Multiples das';
$strings['[today]'] = '[HOY]';
$strings['Day View'] = 'Vista diaria';
$strings['Week View'] = 'Vista semanal';
$strings['Month View'] = 'Vista mensual';
$strings['Resource Calendar'] = 'Calendario de recursos';
$strings['View Resource Calendar'] = 'Calendario de recursos';	// @since 1.2.0
$strings['Signup View'] = 'Vista de inscripcin';

$strings['Select User'] = 'Seleccionar usuario';
$strings['Change'] = 'Cambiar';

$strings['Update'] = 'Actualizar';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'La actualizacin de phpScheduleIt slo esta disponible para las versiones 1.0.0 o posteriores';
$strings['phpScheduleIt is already up to date'] = 'phpScheduleIt ya est actualizado';
$strings['Migrating reservations'] = 'Migrando reservas';

$strings['Admin'] = 'Administrador';
$strings['Manage Announcements'] = 'Anuncios';
$strings['There are no announcements'] = 'No hay anuncios';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Capacidad mxima de participantes';
$strings['Leave blank for unlimited'] = 'Dejar en blanco si la cantidad disponible es ilimitada';
$strings['Maximum of participants'] = 'Este recurso tiene una capacidad mxima de %s participantes';
$strings['That reservation is at full capacity.'] = 'Esta reserva esta a su plena capacidad.';
$strings['Allow registered users to join?'] = 'Permitir que los usuarios registrados se apunten?';
$strings['Allow non-registered users to join?'] = 'Permitir que los usuarios NO registrados se apunten?';
$strings['Join'] = 'Apuntarse';
$strings['My Participation Options'] = 'Mis opciones de participacin';
$strings['Join Reservation'] = 'nete a la reserva';
$strings['Join All Recurring'] = 'nete a todos recurrentemente';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'Usted no est participando en las fechas siguiente reservadas porque estn en plena capacidad.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'Usted ya est invitado a esta reserva. Por favor, siga las instrucciones de la participacin previamente enviado a su correo.';
$strings['Additional Tools'] = 'Herramientas adicionales';
$strings['Create User'] = 'Crear usuario';
$strings['Check Availability'] = 'Comprobar disponibilidad';
$strings['Manage Additional Resources'] = 'Administrar recursos adicionales';
$strings['All Additional Resources'] = 'Todos los recursos adicionales';
$strings['Number Available'] = 'Cantidad disponible';
$strings['Unlimited'] = 'Ilimitada';
$strings['Add Additional Resource'] = 'Aadir recursos adicional';
$strings['Edit Additional Resource'] = 'Modificar recursos adicional';
$strings['Checking'] = 'Comprobando';
$strings['You did not select anything to delete.'] = 'No ha seleccionado nada a eliminar.';
$strings['Added Resources'] = 'Recursos aadidos';
$strings['Additional resource is reserved'] = 'El recurso adicional %s slo tiene %s unidades disponibles al mismo tiempo';
$strings['All Groups'] = 'Todos los grupos';
$strings['Group Name'] = 'Nombre del grupo';
$strings['Delete Groups'] = 'Eliminar grupos';
$strings['Manage Groups'] = 'Grupos';
$strings['None'] = 'Ninguno';
$strings['Group name is required.'] = 'El nombre del grupo es obligatorio';
$strings['Groups'] = 'Grupos';
$strings['Current Groups'] = 'Grupos actuales';
$strings['Group Administration'] = 'Administracin del grupo';
$strings['Reminder Subject'] = 'Recordatorio de la reserva - %s, %s %s';
$strings['Reminder'] = 'Recordatorio';
$strings['before reservation'] = 'antes de la reserva';
$strings['My Participation'] = 'Mi participacin';
$strings['My Past Participation'] = 'Mi participacin pasada';
$strings['Timezone'] = 'Zona horaria';
$strings['Export'] = 'Exportar';
$strings['Select reservations to export'] = 'Seleccionar reservas para exportar';
$strings['Export Format'] = 'Exportar formato';
$strings['This resource cannot be reserved less than x hours in advance'] = 'Este recurso ha de ser reservado con al menos %s horas de antelacin';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Este recurso no puede ser reservado con ms de %s horas de antelacin';
$strings['Minimum Booking Notice'] = 'Antelacin mnima de la reserva';
$strings['Maximum Booking Notice'] = 'Antelacin mxima de la reserva';
$strings['hours prior to the start time'] = 'horas antes del momento de inicio';
$strings['hours from the current time'] = 'horas desde el momento actual';
$strings['Contains'] = 'Contiene';
$strings['Begins with'] = 'Comienza con';
$strings['Minimum booking notice is required.'] = 'Requiere antelacin mnima de la reserva';
$strings['Maximum booking notice is required.'] = 'Requiere antelacin mxima de la reserva';
$strings['Accessory Name'] = 'Nombre del accesorio';
$strings['Accessories'] = 'Accesorios';
$strings['All Accessories'] = 'Todos los accesorios';
$strings['Added Accessories'] = 'Accesorios aadidos';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n\r\n"
				. "Usted se ha registrado correctamente con la siguiente informacin:\r\n"
				. "Usuario: %s\r\n"
				. "Nombre: %s %s \r\n"
				. "Telfono: %s \r\n"
				. "Institucin: %s \r\n"
				. "Cargo: %s \r\n\r\n"
				. "Por favor entre en el sistema de reservas a travs de la siguiente direccin:\r\n"
				. "%s \r\n\r\n"
				. "Usted encontrar enlaces para el sistema de reservas y para modificar su perfil en Mi panel de control.\r\n\r\n"
				. "Por favor dirija sus preguntas relacionadas con reservas y recursos a %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Administrador,\r\n\r\n"
					. "Un nuevo usuario se ha registrado con la siguiente informacin:\r\n"
					. "Correo: %s \r\n"
					. "Nombre: %s %s \r\n"
					. "Telfono: %s \r\n"
					. "Institucin: %s \r\n"
					. "Cargo: %s \r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n\r\n<br />"
			. "Usted ha %s correctamente la reserva #%s.\r\n\r\n<br/><br/>"
			. "Por favor use este nmero de reserva cuando contacte al administrador para alguna pregunta.\r\n\r\n<br/><br/>"
			. "Una reserva entre %s %s y %s %s para %s"
			. " ubicada en %s ha sido %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "Esta reserva se ha repetido en las siguientes fechas:\r\n<br/>";
$email['reservation_activity_3'] = "Todas las reservas recurrentes de esta serie, tambin fueron %ss.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "El siguiente es el resumen de para esta reserva:\r\n\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "Si Usted considera esto un error, por favor contacte al administrador en: %s"
			. " o llamando al %s.\r\n\r\n<br/><br/>"
			. "Usted puede ver o modificar su reserva en cualquier momento"
			. " iniciando sesin en %s en:\r\n\r\n<br/>"
			. "<a href=\"%s\" target=\"_blank\">%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "Por favor dirija las preguntas tcnicas a <a href=\"mailto:%s\">%s</a>.\r\n\r\n<br/><br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n\r\n<br />"
			. "La reserva #%s ha sido aprobada.\r\n\r\n<br/><br/>"
			. "Por favor use este nmero de reserva cuando contacte al administrador para alguna pregunta.\r\n\r\n<br/><br/>"
			. "Una reserva entre %s %s y %s %s para %s"
			. " ubicada en %s ha sido %s.\r\n\r\n<br/><br/>";

// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Su contrasea %s ha sido restablecida por el administrador.\r\n\r\n"
			. "Su contrasea temporal es:\r\n\r\n %s\r\n\r\n"
			. "Por favor use esta contrasea temporal (puede usar copiar y pegar para mayor facilidad) para iniciar sesin en %s en %s"
			. " y cmbiela de inmediato por otra de su eleccin usando la opcin Cambiar perfil en la tabla Mis accesos directos.\r\n\r\n"
			. "Por favor escriba a %s para mayor informacin.";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\n\r\n"
            . "Su nueva contrasea para su cuenta de %s es:\r\n\r\n"
            . "%s\r\n\r\n"
            . "Por favor inicie sesin en %s "
            . "con esta nueva contrasea "
            . "(puede usar copiar y pegar para mayor facilidad) "
            . "y cmbiela de inmediato por otra de su eleccin haciendo click en "
            . "Cambiar perfil en Mi panel de control.\r\n\r\n"
            . "Por favor contacte a %s para mayor informacin.";

// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "%s lo(la) ha invitado para participar en la siguiente reserva:\r\n\r\n"
		. "Recurso: %s\r\n"
		. "Fecha de Inicio: %s\r\n"
		. "Hora de Inicio: %s\r\n"
		. "Fecha de Finalizacin: %s\r\n"
		. "Hora de Finalizacin: %s\r\n"
		. "Resumen: %s\r\n"
		. "Fechas de repeticin (si hay): %s\r\n\r\n"
		. "Para aceptar esta invitacin haga click en este enlace (Use copiar y pegar si no est resaltado) %s\r\n"
		. "Para rechazar esta invitacin haga click en este enlace (Use copiar y pegar si no est resaltado) %s\r\n"
		. "Para aceptar algunas fechas o administrar sus invitaciones despus, por favor ingrese a %s en %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Usted ha sido retirado de la siguiente reserva:\r\n\r\n"
		. "Recurso: %s\r\n"
		. "Fecha de Inicio: %s\r\n"
		. "Hora de Inicio: %s\r\n"
		. "Fecha de Finalizacin: %s\r\n"
		. "Hora de Finalizacin: %s\r\n"
		. "Resumen: %s\r\n"
		. "Fechas de repeticin (si hay): %s\r\n\r\n";

// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "Falta poco para su reserva de %s (desde %s %s a %s %s).";
?>