<?php
/**
* Hungarian (hu) translation file.
*
* @author Nick Korbel <lqqkout13@users.sourceforge.net>
* @translator Attila <atoth@cmr.sote.hu>
* @version 04-04-05
* @package Languages
*
* Copyright (C) 2003 - 2007 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
// Please save the translated file as '2 letter language code'.lang.php.  For example, en.lang.php.
//
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  If there
//  is no direct translation, please provide the closest translation.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//  Also, please add a help translation for your language using en.help.php as a base.
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'iso-8859-2';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('Vasrnap', 'Htf', 'Kedd', 'Szerda', 'Cstrtk', 'Pntek', 'Szombat');
// The three letter abbreviation
$days_abbr = array('Vas', 'Ht', 'Ked', 'Sze', 'Cs', 'Pn', 'Szo');
// The two letter abbreviation
$days_two  = array('Va', 'H', 'Ke', 'Se', 'Cs', 'P', 'So');
// The one letter abbreviation
$days_letter = array('V', 'H', 'K', 'S', 'C', 'P', 'Z');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('Janur', 'Februr', 'Mrcius', 'prilis', 'Mjus', 'Jnius', 'Jlius', 'Augusztus', 'Szeptember', 'Oktber', 'November', 'December');
// The three letter month name
$months_abbr = array('Jan', 'Feb', 'Mr', 'pr', 'Mj', 'Jn', 'Jl', 'Aug', 'Sze', 'Okt', 'Nov', 'Dec');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', '', 'B', 'C', 'D', 'E', '', 'F', 'G', 'H', 'I', '', 'J', 'K', 'L', 'M', 'N', 'O', '', '', '', 'P', 'Q', 'R', 'S', 'T', 'U', '', '', '', 'V', 'W', 'X', 'Y', 'Z');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%Y.%m.%d.';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%Y.%m.%d. @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%Y.%m.%d. %A';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%Y.%m.%d.<br/>%A';
// Date on top-right of each page
$dates['header'] = '%Y. %B %d. %A';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box
$dates['jumpbox'] = '%Y.%m.%d.';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'ra';
$strings['minutes'] = 'perc';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'hh';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'nn';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = '';
$strings['am'] = 'de';
$strings['pm'] = 'du';

$strings['Administrator'] = 'Adminisztrtor';
$strings['Welcome Back'] = 'dvzlet, %s';
$strings['Log Out'] = 'Kilps';
$strings['My Control Panel'] = 'Irnyt Pult';
$strings['Help'] = 'Segtsg';
$strings['Manage Schedules'] = 'Eljegyzs Kezels';
$strings['Manage Users'] ='Felhasznl Kezels';
$strings['Manage Resources'] ='Kontingens Kezels';
$strings['Manage User Training'] ='Felhasznl Kpzs';
$strings['Manage Reservations'] ='Vizsglat Kezels';
$strings['Email Users'] ='Krlevl a Felhasznlknak';
$strings['Export Database Data'] = 'Adatbzis Adatok Exportlsa';
$strings['Reset Password'] = 'Jelsz Visszalltsa';
$strings['System Administration'] = 'Rendszer Adminisztrci';
$strings['Successful update'] = 'Sikeres Frissts!';
$strings['Update failed!'] = 'Sikeretlen Frissts!';
$strings['Manage Blackout Times'] = 'Tiltott Idszak Kezels';
$strings['Forgot Password'] = 'Elfelejtett Jelsz';
$strings['Manage My Email Contacts'] = 'Email Kapcsolat Kezels';
$strings['Choose Date'] = 'Vlasszon Dtumot';
$strings['Modify My Profile'] = 'Profil Mdostsa';
$strings['Register'] = 'Regisztrci';
$strings['Processing Blackout'] = 'Tiltott Idszak Feldolgozsa';
$strings['Processing Reservation'] = 'Vizsglat Feldolgozsa';
$strings['Online Scheduler [Read-only Mode]'] = 'Eljegyzs [Csak Olvashat Md]';
$strings['Online Scheduler'] = 'Eljegyzs';
$strings['phpScheduleIt Statistics'] = 'phpScheduleIt Statisztikk';
$strings['User Info'] = 'Felhasznli Informci:';

$strings['Could not determine tool'] = 'rvnytelen eszkz. Trjen vissza a Vezrl Pulthoz s prblkozzon ismt.';
$strings['This is only accessable to the administrator'] = 'Csak az adminisztrtor szmra elrhet';
$strings['Back to My Control Panel'] = 'Vissza a Vezrl Pulthoz';
$strings['That schedule is not available.'] = 'A vlasztott Eljegyzs nem elrhet.';
$strings['You did not select any schedules to delete.'] = 'Nem vlasztotta ki a trlend Eljegyzst.';
$strings['You did not select any members to delete.'] = 'Nem vlasztotta ki a trlend Felhasznlt.';
$strings['You did not select any resources to delete.'] = 'Nem vlasztotta ki a trlend Kontingenst.';
$strings['Schedule title is required.'] = 'Az Eljegyzs tartalmnak megadsa ktelez.';
$strings['Invalid start/end times'] = 'rvnytelen kezd/befejez idpont';
$strings['View days is required'] = 'Megjelentend napok szmnak megadsa ktelez';
$strings['Day offset is required'] = 'Az Eljegyzs minimlis idbeli tvolsgnak megadsa ktelez';
$strings['Admin email is required'] = 'Az Adminisztrtor email cmnek megadsa ktelez';
$strings['Resource name is required.'] = 'A Kontingens megnevezse ktelez.';
$strings['Valid schedule must be selected'] = 'rvnyes Eljegyzs nevnek megadsa ktelez';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'A legrvidebb vizsglati idtartam nem haladhatja meg a maximlis idtartamot.';
$strings['Your request was processed successfully.'] = 'A krst a Rendszer sikeresen feldolgozta.';
$strings['Go back to system administration'] = 'Vissza a Rendszer Adminisztrcihoz';
$strings['Or wait to be automatically redirected there.'] = 'Vagy vrja meg, amg automatikusan tirnytdik.';
$strings['There were problems processing your request.'] = 'Hiba trtnt a krs feldolgozs kzben.';
$strings['Please go back and correct any errors.'] = 'Krem menjen vissza s javtson ki minden hibt.';
$strings['Login to view details and place reservations'] = 'A rszletek megtekintshez s vizsglat eljegyzshez jelentkezzen be';
$strings['Memberid is not available.'] = 'Az Azonost: %s nem hasznlhat.';

$strings['Schedule Title'] = 'Eljegyzs Megnevezse';
$strings['Start Time'] = 'Kezd idpont';
$strings['End Time'] = 'Befejez idpont';
$strings['Time Span'] = 'Idtartam';
$strings['Weekday Start'] = 'A Ht Kezd Napja';
$strings['Admin Email'] = 'Admin Email';

$strings['Default'] = 'Alaprtelmezett';
$strings['Reset'] = 'Visszallt';
$strings['Edit'] = 'Szerkeszts';
$strings['Delete'] = 'Trls';
$strings['Cancel'] = 'Mgse';
$strings['View'] = 'Megtekint';
$strings['Modify'] = 'Mdosts';
$strings['Save'] = 'Ments';
$strings['Back'] = 'Vissza';
$strings['Next'] = 'Elre';
$strings['Close Window'] = 'Ablak Bezrsa';
$strings['Search'] = 'Keress';
$strings['Clear'] = 'Kitrls';

$strings['Days to Show'] = 'Megjelentend Napok Szma';
$strings['Reservation Offset'] = 'Eljegyzs minimlis idbeli tvolsga';
$strings['Hidden'] = 'Rejtett';
$strings['Show Summary'] = 'sszegzs Megjelentse';
$strings['Add Schedule'] = 'j Eljegyzs Hozzadsa';
$strings['Edit Schedule'] = 'Eljegyzs Szerkesztse';
$strings['No'] = 'Nem';
$strings['Yes'] = 'Igen';
$strings['Name'] = 'Nv';
$strings['First Name'] = 'Vezetknv';
$strings['Last Name'] = 'Keresztnv';
$strings['Resource Name'] = 'Kontingens Neve';
$strings['Email'] = 'Email cm';
$strings['Institution'] = 'Intzmny';
$strings['Phone'] = 'Telefon';
$strings['Password'] = 'Jelsz';
$strings['Permissions'] = 'Jogosultsgok';
$strings['View information about'] = 'Tjkoztat megtekintse a kvetkez felhasznlrl: %s %s';
$strings['Send email to'] = 'Email kldse a kvetkez felhasznlnak: %s %s';
$strings['Reset password for'] = 'A kvetkez felhasznl jelszavnak tlltsa: %s %s';
$strings['Edit permissions for'] = 'A kvetkez felhasznl jogosultsgainak szerkesztse: %s %s';
$strings['Position'] = 'Beoszts';
$strings['Password (6 char min)'] = 'Jelsz (minimum %s bet)'; // @since 1.1.0
$strings['Re-Enter Password'] = 'A jelsz ismtelt megadsa';

$strings['Sort by descending last name'] = 'Cskken sorrend a Keresztnv alapjn';
$strings['Sort by descending email address'] = 'Cskken sorrend az Email cm alapjn';
$strings['Sort by descending institution'] = 'Cskken sorrend az Intzmny megnevezse alapjn';
$strings['Sort by ascending last name'] = 'Emelked sorrend a Keresztnv alapjn';
$strings['Sort by ascending email address'] = 'Emelked sorrend az Email cm alapjn';
$strings['Sort by ascending institution'] = 'Emelked sorrend az Intzmny megnevezse alapjn';
$strings['Sort by descending resource name'] = 'Cskken sorrend a Kontingens neve alapjn';
$strings['Sort by descending location'] = 'Cskken sorrend Helyszn alapjn';
$strings['Sort by descending schedule title'] = 'Cskken sorrend az Eljegyzs megnevezse alapjn';
$strings['Sort by ascending resource name'] = 'Emelked sorrend a Kontingens neve alapjn';
$strings['Sort by ascending location'] = 'Emelked sorrend Helyszn alapjn';
$strings['Sort by ascending schedule title'] = 'Emelked sorrend az Eljegyzs megnevezse alapjn';
$strings['Sort by descending date'] = 'Cskken sorrend a dtum alapjn';
$strings['Sort by descending user name'] = 'Cskken sorrend Felhasznli nv alapjn';
$strings['Sort by descending start time'] = 'Cskken sorrend a Kezd idpont alapjn';
$strings['Sort by descending end time'] = 'Cskken sorrend a Befejez idpont alapjn';
$strings['Sort by ascending date'] = 'Emelked sorrend dtum alapjn';
$strings['Sort by ascending user name'] = 'Emelked sorrend a Felhasznl nv alapjn';
$strings['Sort by ascending start time'] = 'Emelked sorrend a Kezd idpont alapjn';
$strings['Sort by ascending end time'] = 'Emelked sorrend a Befejez idpont alapjn';
$strings['Sort by descending created time'] = 'Cskken sorrend a Ltrehozs dtuma alapjn';
$strings['Sort by ascending created time'] = 'Emelked sorrend a Ltrehozs dtuma alapjn';
$strings['Sort by descending last modified time'] = 'Cskken sorrend az utols Mdosts ideje alapjn';
$strings['Sort by ascending last modified time'] = 'Emelked sorrend az utols Mdosts ideje alapjn';

$strings['Search Users'] = 'Felhasznl Keresse';
$strings['Location'] = 'Helyszn';
$strings['Schedule'] = 'Eljegyzs';
$strings['Phone'] = 'Telefon';
$strings['Notes'] = 'Megjegyzs';
$strings['Status'] = 'llapot';
$strings['All Schedules'] = 'Minden Eljegyzs';
$strings['All Resources'] = 'Minden Kontingens';
$strings['All Users'] = 'Minden Felhasznl';

$strings['Edit data for'] = 'A kvetkez adatainak szerkesztse: %s';
$strings['Active'] = 'Aktv';
$strings['Inactive'] = 'Inaktv';
$strings['Toggle this resource active/inactive'] = 'A Kontingens aktivlsa/inaktivlsa';
$strings['Minimum Reservation Time'] = 'Minimum Vizsglati idtartam';
$strings['Maximum Reservation Time'] = 'Maximum Vizsglati idtartam';
$strings['Auto-assign permission'] = 'Jogosultsgok Automatikus Kiosztsa';
$strings['Add Resource'] = 'Kontingens Hozzadsa';
$strings['Edit Resource'] = 'Kontingens Szerkesztse';
$strings['Allowed'] = 'Engedlyezett';
$strings['Notify user'] = 'Felhasznl rtestse';
$strings['User Reservations'] = 'Felhasznl Vizsglatai';
$strings['Date'] = 'Dtum';
$strings['User'] = 'Felhasznl';
$strings['Email Users'] = 'Krlevl kldse felhasznl(k)nak';
$strings['Subject'] = 'Trgy';
$strings['Message'] = 'Szveg';
$strings['Please select users'] = 'Vlasszon Felhasznlt';
$strings['Send Email'] = 'Email Kldse';
$strings['problem sending email'] = 'Problma addott az email kldse sorn. Krem prblja jra ksbb.';
$strings['The email sent successfully.'] = 'Az emailt sikerlt postzni.';
$strings['do not refresh page'] = 'Krem <u>NE</u> frisstse ezt az oldalt, mert az email jra elkldsre kerl.';
$strings['Return to email management'] = 'Visszatrs az Email Kezelshez';
$strings['Please select which tables and fields to export'] = 'Krem vlassza ki, hogy melyik tblt s mezt kvnja exportlni:';
$strings['all fields'] = '- minden mez -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Sima szveg';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'Adatok Exportlsa';
$strings['Reset Password for'] = '%s Jelszavnak visszalltsa';
$strings['Please edit your profile'] = 'Krem hajtsa vgre Profiljn a kvnt vltoztatsokat';
$strings['Please register'] = 'Krem Regisztrljon';
$strings['Keep me logged in'] = 'A Rendszer rizzen meg bejelentkezett llapotban <br/>(cookie tmogats szksges)';
$strings['Edit Profile'] = 'Profil Szerkesztse';
$strings['Register'] = 'Regisztrci';
$strings['Please Log In'] = 'Krem Jelentkezzen Be';
$strings['Email address'] = 'Email Cm';
$strings['Password'] = 'Jelsz';
$strings['First time user'] = 'Els Alkalom?';
$strings['Click here to register'] = 'Kattintson ide a regisztrcihoz';
$strings['Register for phpScheduleIt'] = 'Regisztrci a phpScheduleIt Rendszerbe';
$strings['Log In'] = 'Bejelentkezs';
$strings['View Schedule'] = 'Eljegyzsek Megtekintse';
$strings['View a read-only version of the schedule'] = 'Megtekints Csak Olvashat Mdban';
$strings['I Forgot My Password'] = 'Elfelejtett Jelsz';
$strings['Retreive lost password'] = 'Elfelejtett jelsz elkrse';
$strings['Get online help'] = 'Online Segtsg';
$strings['Language'] = 'Nyelv';
$strings['(Default)'] = '(Alaprtelmezett)';

$strings['My Announcements'] = 'Bejelentsek';
$strings['My Reservations'] = 'Vizsglatok';
$strings['My Permissions'] = 'Jogosultsgok';
$strings['My Quick Links'] = 'Gyors Linkek';
$strings['Announcements as of'] = 'Bejelentsek %s';
$strings['There are no announcements.'] = 'Nincsen Bejelents.';
$strings['Resource'] = 'Kontingens';
$strings['Created'] = 'Ltrehozs';
$strings['Last Modified'] = 'Utols Mdosts';
$strings['View this reservation'] = 'Vizsglat megtekintse';
$strings['Modify this reservation'] = 'Vizsglat mdostsa';
$strings['Delete this reservation'] = 'Vizsglat trlse';
$strings['Bookings'] = 'Eljegyzs';
$strings['Change My Profile Information/Password'] = 'Profil Szerkeszts/Jelsz Vlts'; // @since 1.2.0
$strings['Manage My Email Preferences'] = 'Email Belltsok Szerkesztse'; // @since 1.2.0
$strings['Mass Email Users'] = 'Kremail kldse';
$strings['Search Scheduled Resource Usage'] = 'Keress a kontingensek kihasznltsgi adatai kztt'; // @since 1.2.0
$strings['Export Database Content'] = 'Adatbzis Tartalom Exportlsa';
$strings['View System Stats'] = 'Rendszer Statisztika Megtekintse';
$strings['Email Administrator'] = 'Email Kldse az Adminisztrtornak';

$strings['Email me when'] = 'Email kldse a kvetkez esetben:';
$strings['I place a reservation'] = 'Vizsglat eljegyzse';
$strings['My reservation is modified'] = 'Eljegyzett vizsglat mdosttsa';
$strings['My reservation is deleted'] = 'Eljegyzett vizsglat trlse';
$strings['I prefer'] = 'Elnyben rszestett formtum:';
$strings['Your email preferences were successfully saved'] = 'Az email belltsok sikeresen trolsra kerltek!';
$strings['Return to My Control Panel'] = 'Vissza a Vezrl Pulthoz';

$strings['Please select the starting and ending times'] = 'Vlaszthat egy kezd s egy befejez idpontot:';
$strings['Please change the starting and ending times'] = 'Mdosthatja a kezd s a befejez idpontot:';
$strings['Reserved time'] = 'Fenntartott idtartam:';
$strings['Minimum Reservation Length'] = 'Minimum Vizsglati Id:';
$strings['Maximum Reservation Length'] = 'Maximum Vizsglati Id:';
$strings['Reserved for'] = 'Fenntartva:';
$strings['Will be reserved for'] = 'Vizsglatot eljegyz felhasznl:';
$strings['N/A'] = 'N/A';
$strings['Update all recurring records in group'] = 'Ismtelt Elforduls(ok) Frisstse';
$strings['Delete?'] = 'Trls?';
$strings['Never'] = '-- Soha --';
$strings['Days'] = 'Naponta';
$strings['Weeks'] = 'Hetenknt';
$strings['Months (date)'] = 'Hnapban (Dtum)';
$strings['Months (day)'] = 'Hnapban (Nap)';
$strings['First Days'] = 'Els nap';
$strings['Second Days'] = 'Msodik napon';
$strings['Third Days'] = 'Harmadik napon';
$strings['Fourth Days'] = 'Negyedik napon';
$strings['Last Days'] = 'Utols nap';
$strings['Repeat every'] = 'Ismtelt elforduls:';
$strings['Repeat on'] = 'Ismtldjn:';
$strings['Repeat until date'] = 'Ismtldjn a kvetkez idpontig:';
$strings['Choose Date'] = 'Vlasszon dtumot';
$strings['Summary'] = 'sszegzs';

$strings['View schedule'] = 'Eljegyzs megtekintse:';
$strings['My Reservations'] = 'Sajt Vizsglat';
$strings['My Past Reservations'] = 'Lejrt Sajt Vizsglat';
$strings['Other Reservations'] = 'Egyb Vizsglat';
$strings['Other Past Reservations'] = 'Lejrt Egyb Vizsglat';
$strings['Blacked Out Time'] = 'Tiltott Idpont';
$strings['Set blackout times'] = 'Idpont Tiltsa %s %s';
$strings['Reserve on'] = 'Reserve %s on %s';
$strings['Prev Week'] = '&laquo; Elz Ht';
$strings['Jump 1 week back'] = '1 Httel Vissza';
$strings['Prev days'] = '&#8249; Elz %d nap';
$strings['Previous days'] = '&#8249; Elz %d nap';
$strings['This Week'] = 'Aktulis Ht';
$strings['Jump to this week'] = 'Ugrs erre a htre';
$strings['Next days'] = 'Kvetkez %d nap &#8250;';
$strings['Next Week'] = 'Kvetkez ht &raquo;';
$strings['Jump To Date'] = 'Ugrs erre a napra';
$strings['View Monthly Calendar'] = 'Naptr Megtekintse Havi Bontsban';
$strings['Open up a navigational calendar'] = 'Navigl naptr megnyitsa';

$strings['View stats for schedule'] = 'Eljegyzs statisztikinak megjelentse:';
$strings['At A Glance'] = 'Egy Pillantra';
$strings['Total Users'] = 'sszes Felhasznl:';
$strings['Total Resources'] = 'sszes Kontingens:';
$strings['Total Reservations'] = 'sszes Vizsglat:';
$strings['Max Reservation'] = 'Maximum Vizsglat:';
$strings['Min Reservation'] = 'Minimum Vizsglat:';
$strings['Avg Reservation'] = 'tlagos Vizsglat:';
$strings['Most Active Resource'] = 'Legaktvabb Kontingens:';
$strings['Most Active User'] = 'Legaktvabb Felhasznl:';
$strings['System Stats'] = 'Rendszer Statisztika';
$strings['phpScheduleIt version'] = 'phpScheduleIt verzi:';
$strings['Database backend'] = 'Adatbzis backend:';
$strings['Database name'] = 'Adatbzis nv:';
$strings['PHP version'] = 'PHP verziszm:';
$strings['Server OS'] = 'Szerver OS:';
$strings['Server name'] = 'Szerver nv:';
$strings['phpScheduleIt root directory'] = 'phpScheduleIt gykr knyvtr:';
$strings['Using permissions'] = 'Jogosultsg kezels hasznlata:';
$strings['Using logging'] = 'Naplzs hasznlata:';
$strings['Log file'] = 'Napl fjl:';
$strings['Admin email address'] = 'Adminisztrtor email cme:';
$strings['Tech email address'] = 'Technikai tmogats email cme:';
$strings['CC email addresses'] = 'CC email cm:';
$strings['Reservation start time'] = 'Vizsglat kezd idpont:';
$strings['Reservation end time'] = 'Vizsglat befejez idpont:';
$strings['Days shown at a time'] = 'Egyszerre megjelntett napok:';
$strings['Reservations'] = 'Vizsglati eljegyzs';
$strings['Return to top'] = 'Vissza a tetejre';
$strings['for'] = ':';

$strings['Select Search Criteria'] = 'Keressi Felttel Kivlasztsa';
$strings['Schedules'] = 'Eljegyzsek:';
$strings['All Schedules'] = 'sszes Eljegyzs';
$strings['Hold CTRL to select multiple'] = 'Tbbszrs vlasztshoz tartsa lenyomva a CTRL-t';
$strings['Users'] = 'Felhasznlk:';
$strings['All Users'] = 'sszes Felhasznl';
$strings['Resources'] = 'Kontingens:'; // @since 1.2.0
$strings['All Resources'] = 'sszes Kontingens';
$strings['Starting Date'] = 'Kezd Dtum:';
$strings['Ending Date'] = 'Befejez Dtum:';
$strings['Starting Time'] = 'Kezd Idpont:';
$strings['Ending Time'] = 'Befejez Idpont:';
$strings['Output Type'] = 'Kijelzsi Md:';
$strings['Manage'] = 'Kezels';
$strings['Total Time'] = 'sszestett Idtartam';
$strings['Total hours'] = 'sszestett rk:';
$strings['% of total resource time'] = '%-a az sszes Vizsglati Idnek';
$strings['View these results as'] = 'Az eredmnyek megtekintse a kvetkezkppen:';
$strings['Edit this reservation'] = 'A Vizsglat szerkesztse';
$strings['Search Results'] = 'Keress Eredmnye';
$strings['Search Resource Usage'] = 'Kontingens Kihasznltsg szerinti keress';
$strings['Search Results found'] = 'Keress Eredmnye: %d Tallat';
$strings['Try a different search'] = 'Msik keress';
$strings['Search Run On'] = 'Keress a Kvetkezn Futott:';
$strings['Member ID'] = 'Felhasznli Azonost';
$strings['Previous User'] = '&laquo; Elz Felhasznl';
$strings['Next User'] = 'Kvetkez Felhasznl &raquo;';

$strings['No results'] = 'Nincs Tallat';
$strings['That record could not be found.'] = 'Ilyen Bejegyzs nem tallhat..';
$strings['This blackout is not recurring.'] = 'A Tiltott Idpont nem ismtldik.';
$strings['This reservation is not recurring.'] = 'A Vizsglat nem ismtldik.';
$strings['There are no records in the table.'] = 'Nincs egy Bejegyzs sem a kvetkez Tblban: %s.';
$strings['You do not have any reservations scheduled.'] = 'Nem tallhat n ltal eljegyzett Vizsglat.';
$strings['You do not have permission to use any resources.'] = 'nnek egyik Kontingens hasznlathoz sincs joga.';
$strings['No resources in the database.'] = 'Nincs Kontingens az adatbzisban.';
$strings['There was an error executing your query'] = 'Hiba trtnt a krs feldolgozsa kzben:';

$strings['That cookie seems to be invalid'] = 'A Cookie rvnytelennek tnik';
$strings['We could not find that logon in our database.'] = 'Nem tallhat ilyen Elrs az adatbzisban.';	// @since 1.1.0
$strings['That password did not match the one in our database.'] = 'A megadott Jelsz s/vagy Azonost nem egyezik az adatbzisban szereplvel.';
$strings['You can try'] = '<br />Regisztrljon magt az<br />eljegyzsi rendszerhez,<br />vagy prbljon meg<br />jbl bejelentkezni.';
$strings['A new user has been added'] = 'Az j Felhasznl bejegyzsre kerlt';
$strings['You have successfully registered'] = 'Sikeres Regisztrci!';
$strings['Continue'] = 'Folytats...';
$strings['Your profile has been successfully updated!'] = 'A Profil sikeresen frisstsre kerlt!';
$strings['Please return to My Control Panel'] = 'Krem trjen vissza a Vezrl Pulthoz';
$strings['Valid email address is required.'] = '- Vals email cm megadsa szksges.';
$strings['First name is required.'] = '- Vezetknv megadsa ktelez.';
$strings['Last name is required.'] = '- Keresztnv megadsa ktelez.';
$strings['Phone number is required.'] = '- Telefonszm megadsa ktelez.';
$strings['That email is taken already.'] = '- A megadott email cm foglalt.<br />Krem vlasszon egy msikat.';
$strings['Min 6 character password is required.'] = '- Min %s bet hossz jelsz megadsa szksges.';
$strings['Passwords do not match.'] = '- A jelsz nem egyezik.';

$strings['Per page'] = 'Oldalanknt:';
$strings['Page'] = 'Oldal:';

$strings['Your reservation was successfully created'] = 'A Vizsglat sikeresen bejegyzsre kerlt';
$strings['Your reservation was successfully modified'] = 'A Vizsglat sikeresen mdostsra kerlt';
$strings['Your reservation was successfully deleted'] = 'A Vizsglat sikeresen trlsre kerlt';
$strings['Your blackout was successfully created'] = 'A Tiltott Idpont sikeresen bejegyzsre kerlt';
$strings['Your blackout was successfully modified'] = 'A Tiltott Idpont sikeresen mdostsra kerlt';
$strings['Your blackout was successfully deleted'] = 'A Tiltott Idpont sikeresen trlsre kerlt';
$strings['for the follwing dates'] = 'az albbi idpont(ok)ban:';
$strings['Start time must be less than end time'] = 'A Kezd Idpontnak korbbinak kell lenni a Befejez Idpontnl';
$strings['Current start time is'] = 'Aktulis Kezd Idpont:';
$strings['Current end time is'] = 'Aktulis Befejez Idpont:';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'A Vizsglat megadott hossza nem teljesti az idtartammal kapcsolatban\ meghatrozott feltteleket.';
$strings['Your reservation is'] = 'Az n Vizsglata:';
$strings['Minimum reservation length'] = 'Minimlis Vizsglati Idtartam:';
$strings['Maximum reservation length'] = 'Maximlis Vizsglati Idtartam:';
$strings['You do not have permission to use this resource.'] = 'Nincs Jogosultsga az adott Kontingens hasznlathoz.';
$strings['reserved or unavailable'] = 'az %s %s foglalt, vagy nem hasznlhat.';	// @since 1.1.0
$strings['Reservation created for'] = 'Vizsglat ltrehozva %s';
$strings['Reservation modified for'] = 'Vizsglat mdostva %s';
$strings['Reservation deleted for'] = 'Vizsglat trlve %s';
$strings['created'] = 'ltrehozta';
$strings['modified'] = 'mdostotta';
$strings['deleted'] = 'trlte';
$strings['Reservation #'] = 'Vizsglat #';
$strings['Contact'] = 'Kapcsolat';
$strings['Reservation created'] = 'Vizsglat ltrehozva';
$strings['Reservation modified'] = 'Vizsglat mdostva';
$strings['Reservation deleted'] = 'Vizsglat trlve';

$strings['Reservations by month'] = 'Vizsglatok Hnapos Bontsban';
$strings['Reservations by day of the week'] = 'Vizsglatok Napos Bontsban';
$strings['Reservations per month'] = 'Vizsglatok Hnaponknt';
$strings['Reservations per user'] = 'Vizsglatok Felhasznlnknt';
$strings['Reservations per resource'] = 'Vizsglatok Kontingensenknt';
$strings['Reservations per start time'] = 'Vizsglatok Kezd Idpont Alapjn';
$strings['Reservations per end time'] = 'Vizsglatok Befejez Idpont Alapjn';
$strings['[All Reservations]'] = '[Minden Vizsglat]';

$strings['Permissions Updated'] = 'Frissltek a Jogosultsgok';
$strings['Your permissions have been updated'] = '%s Jogosultsgok frisstsre kerltek';
$strings['You now do not have permission to use any resources.'] = 'Egy Kontingens hasznlathoz sincs Jogosultsga.';
$strings['You now have permission to use the following resources'] = 'Mostantl Jogosultsggal rendelkezik a kvetkez Kontingens(ek) hasznlathoz:';
$strings['Please contact with any questions.'] = 'Krds esetn krem vegye fel a kapcsolatot a kvetkezvel: %s.';
$strings['Password Reset'] = 'Jelsz Visszalltva';

$strings['This will change your password to a new, randomly generated one.'] = 'Ezzel Jelszava vletlenszerre fog vltozni.';
$strings['your new password will be set'] = 'Miutn megadta az Email cmt s a "Jelsz Megvltoztatsa" gombra kattint, az jdonslt Jelszavt a rendszer regisztrlja s elkldi nnek Email-ben.';
$strings['Change Password'] = 'Jelsz Megvltoztatsa';
$strings['Sorry, we could not find that user in the database.'] = 'Sajnos a megadott Felhasznl nem tallhat meg az adatbzisban.';
$strings['Your New Password'] = 'Az n j %s Jelszava';
$strings['Your new passsword has been emailed to you.'] = 'Elkszlt!<br />'
    			. 'Az jdonslt Jelszavt a Rendszer elkldte nnek.<br />'
    			. 'Krem ellenrizze postafikjt s a nytlapon Kattintson a <a href="index.php">Bejelentkezs</a> linkre.'
    			. ' Hasznlja az j Jelszavt s vltoztassa meg azonnal a &quot;Profil Szerkesztse/Jelsz Megvltoztatsa&quot;'
    			. ' menpont alatt a Vezrl Pultban.';

$strings['You are not logged in!'] = 'Nincs Bejelentkezve!';

$strings['Setup'] = 'Telepts';
$strings['Please log into your database'] = 'Krem jelentkezzen be az adatbzisba';
$strings['Enter database root username'] = 'Adja meg az adatbzis felhasznljnak azonostjt:';
$strings['Enter database root password'] = 'Adja meg az adatbzis felhasznljnak jelszavt:';
$strings['Login to database'] = 'Bejelentkezs az adatbzisba';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = 'Az adatbzis root felhasznljnak megadsa <b>nem</b> szksges. Brmely adatbzis felhasznl megfelel, amelynek van jogosultsga a tblk ltrehozsra.';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'Ezzel teleptsre kerl minden szksges phpScheduleIt Adatbzis s Tbla.';
$strings['It also populates any required tables.'] = 'Valamint feltlti a szksges Tblkat.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Figyelmeztets: MINDEN KORBBI ADAT TRLSRE KERL A phpScheduleIt ADATBZISBL!';
$strings['Not a valid database type in the config.php file.'] = 'rvnytelen adatbzis tpus szerepel a config.php fjlban.';
$strings['Database user password is not set in the config.php file.'] = 'Az adatbzis felhasznljnak jelszava nincs megadva a config.php fjlban.';
$strings['Database name not set in the config.php file.'] = 'Az adatbzis neve nincs megadva config.php fjlban.';
$strings['Successfully connected as'] = 'Sikeres kapcsolds a kvetkez nven';
$strings['Create tables'] = 'Tblk ltrehozsa &gt;';
$strings['There were errors during the install.'] = 'Hiba trtnt a telepts sorn. Elkpzelhet, hogy a phpScheduleIt mgis mkdni fog, amennyiben ez csak kis jelentsg volt.<br/><br/>'
	. 'Krdsekkel keresse fel a projekt frumt a <a href="http://sourceforge.net/forum/?group_id=95547">SourceForge</a>-on.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'A phpScheduleIt teleptse sikeresen befejezdtt s a Rendszer hasznlatra ksz.';
$strings['Thank you for using phpScheduleIt'] = 'Krem bizonyosodjon meg rla, hogy a \'install\' KNYVTRAT TELJESEN ELTVOLTOTTA.'
	. ' A knyvtr trlse alapvet biztonsgi krds, mert bizalmas informcikat (adatbzis jelsz) tartalmaz.'
	. ' Elmulasztsa szles biztonsgi rst hagy nyitva, melyen t brmikor betrhetnek az adatbzisba!'
	. '<br /><br />'
	. 'Ksznet, amirt a phpScheduleIt-et vlasztotta!';
$strings['There is no way to undo this action'] = 'A kvetkez beavatkozs visszalltsra nincs lehetsg!';
$strings['Click to proceed'] = 'Kattintson a tovbblpshez';
$strings['Please delete this file.'] = 'Krem trlje ezt a fjlt.';
$strings['Successful update'] = 'A Korszersts sikerrel jrt';
$strings['Patch completed successfully'] = 'A foltozs sikeresen befejezdtt';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'Ha nincs megadva jelsz, akkor a rendszer konfigurcis fjlban trolt alaprtelmezett jelszt fogja hasznlni.';
$strings['Notify user that password has been changed?'] = 'Kapjon rtestst a felhasznl a jelsz vltozsrl?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'A rendszer hasznlatnak elfelttele, hogy legyen egy email cme.';
$strings['Invalid User Name/Password.'] = 'rvnytelen Felhasznl Nv/Jelsz.';
$strings['Pending User Reservations'] = 'Az Vizsglat(ok) bejegyzse a jvhagys(uk)ig felfggesztsre kerlt';
$strings['Approve'] = 'Jvhagys';
$strings['Approve this reservation'] = 'A vizsglat jvhagysa';
$strings['Approve Reservations'] ='Vizsglat(ok) jvhagysa';

$strings['Announcement'] = 'Bejelents';
$strings['Number'] = 'Szm';
$strings['Add Announcement'] = 'Bejelents Hozzadsa';
$strings['Edit Announcement'] = 'Bejelents Szerkesztse';
$strings['All Announcements'] = 'Minden Bejelents';
$strings['Delete Announcements'] = 'Bejelents Trlse';
$strings['Use start date/time?'] = 'Hasznljon kezd dtumot/idpontot?';
$strings['Use end date/time?'] = 'Hasznljon befejez dtumot/idpontot?';
$strings['Announcement text is required.'] = 'A Bejelents szvegnek megadsa ktelez.';
$strings['Announcement number is required.'] = 'A Bejelents szmnak megadsa ktelez.';

$strings['Pending Approval'] = 'A Jvhagys fggben van';
$strings['My reservation is approved'] = 'A vizsglata jvhagysra kerlt';
$strings['This reservation must be approved by the administrator.'] = 'A vizsglatot az Adminisztrtornak jv kell hagynia.';
$strings['Approval Required'] = 'Jvhagys Szksges';
$strings['No reservations requiring approval'] = 'Nincsen olyan vizsglat, amely jvhagysra vr';
$strings['Your reservation was successfully approved'] = 'A vizsglatt sikeresen jvhagytk';
$strings['Reservation approved for'] = 'A vizsglat jvhagysra kerlt a kvetkez szmra: %s';
$strings['approved'] = 'Jvhagyva';
$strings['Reservation approved'] = 'Vizsglat jvhagyva.';

$strings['Valid username is required'] = 'rvnyes Felhasznl Nv szksges';
$strings['That logon name is taken already.'] = 'A Felhasznl Nv mr foglalt.';
$strings['this will be your login'] = '(ez lesz a Felhasznl Neve)';
$strings['Logon name'] = 'Felhasznl Nv';
$strings['Your logon name is'] = 'Az n Felhasznl Neve %s';

$strings['Start'] = 'Kezds';
$strings['End'] = 'Befejezs';
$strings['Start date must be less than or equal to end date'] = 'A Kezd idpontnak korbbinak kell lennie a Befejez idpontnl';
$strings['That starting date has already passed'] = 'A Kezd idpont mr elmlt';
$strings['Basic'] = 'Alap';
$strings['Participants'] = 'Rsztvevk';
$strings['Close'] = 'Bezrs';
$strings['Start Date'] = 'Kezd dtum';
$strings['End Date'] = 'Befejez dtum';
$strings['Minimum'] = 'Minimum';
$strings['Maximum'] = 'Maximum';
$strings['Allow Multiple Day Reservations'] = 'Tbbnapos Vizsglatok enegedlyezse';
$strings['Invited Users'] = 'Meghvott Felhasznlk';
$strings['Invite Users'] = 'Felhasznl(k) Meghvsa';
$strings['Remove Participants'] = 'Rsztvev(k) Eltvoltsa';
$strings['Reservation Invitation'] = 'Meghvsos Vizsglat';
$strings['Manage Invites'] = 'Meghvsok kezelse';
$strings['No invite was selected'] = 'Nem jellt ki Meghvst';
$strings['reservation accepted'] = '%s elfogadta a Meghvst a kvetkezre: %s';
$strings['reservation declined'] = '%s visszautastotta a Meghvst a kvetkezre: %s';
$strings['Login to manage all of your invitiations'] = 'Lpjen be a Rendszerbe Meghvsai kezelshez';
$strings['Reservation Participation Change'] = 'Rszvtel Megvltoztatsa';
$strings['My Invitations'] = 'Meghvsok';
$strings['Accept'] = 'Elfogads';
$strings['Decline'] = 'Visszautasts';
$strings['Accept or decline this reservation'] = 'Fogadja el, vagy utastsa vissza a Meghvst';
$strings['My Reservation Participation'] = 'Rszvtelek';
$strings['End Participation'] = 'Rszvtel Vge';
$strings['Owner'] = 'Tulajdonos';
$strings['Particpating Users'] = 'Rsztvev Felhasznlk';
$strings['No advanced options available'] = 'Nincs elrhet tovbbi opci';
$strings['Confirm reservation participation'] = 'Vizsglati eljegyzsben val rszvtel megerstse';
$strings['Confirm'] = 'Megersts';
$strings['Do for all reservations in the group?'] = 'Alkalmazza a csoportban szerepl sszes vizsglatra?';

$strings['My Calendar'] = 'Sajt Naptr';
$strings['View My Calendar'] = 'Sajt Naptr Megtekintse';
$strings['Participant'] = 'Rsztvev(k)';
$strings['Recurring'] = 'Ismtld';
$strings['Multiple Day'] = 'Tbbnapos';
$strings['[today]'] = '[ma]';
$strings['Day View'] = 'Napi Bonts';
$strings['Week View'] = 'Heti Bonts';
$strings['Month View'] = 'Havi Bonts';
$strings['Resource Calendar'] = 'Kontingens Naptr';
$strings['View Resource Calendar'] = 'Kontingens Naptr Megtekintse';
$strings['Signup View'] = 'Lista Nzet';

$strings['Select User'] = 'Felhasznl Kivlasztsa';
$strings['Change'] = 'Mdosts';

$strings['Update'] = 'Frissts';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'phpScheduleIt Korszersts csak 1.0.0 vagy ksbbi vltozathoz elrhet';
$strings['phpScheduleIt is already up to date'] = 'A phpScheduleIt napraksz llapotban van';
$strings['Migrating reservations'] = 'Vizsglatok tvtele';

$strings['Admin'] = 'Adminisztrtor';
$strings['Manage Announcements'] = 'Bejelents Kezels';
$strings['There are no announcements'] = 'Nincs rvnyes Bejelents';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Rsztvevk Maximlis Szma';
$strings['Leave blank for unlimited'] = 'Hagyja szabadon korltlan szm Rsztvevhz';
$strings['Maximum of participants'] = 'A vizsglati eljegyzsnek maximum %s rsztvevje lehet';
$strings['That reservation is at full capacity.'] = 'A vizsglati eljegyzs elrte a maximlis rsztvev szmot.';
$strings['Allow registered users to join?'] = 'Engedlyezi regisztrlt felhasznlk rszvtelt?';
$strings['Allow non-registered users to join?'] = 'Engedlyezi nem regisztrlt felhasznlk rszvtelt?';
$strings['Join'] = 'Csatlakozs';
$strings['My Participation Options'] = 'Rszvteli Belltsok';
$strings['Join Reservation'] = 'Csatlakozs a vizsglati eljegyzshez';
$strings['Join All Recurring'] = 'Csatlakozs Minden Ismtldhz';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'Nem csatlakozhat a kvetkez vizsglati eljegyzs(ek)hez a rsztvevk maximlis szma miatt.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'Mr meghivtk ehhez a vizsglati eljegyzshez. Krem kvesse a rszvteli utastsokat, melyeket korbban emailben kapott.';
$strings['Additional Tools'] = 'Tovbbi Eszkzk';
$strings['Create User'] = 'Felhasznl Ltrehozsa';
$strings['Check Availability'] = 'Elrhetsg ellenrzse';
$strings['Manage Additional Resources'] = 'Kiegszt Hozzadsa';
$strings['Number Available'] = 'Szm Elrhet';
$strings['Unlimited'] = 'Korltlan';
$strings['Add Additional Resource'] = 'Kiegszt Kontingens Hozzadsa';
$strings['Edit Additional Resource'] = 'Kiegszt Szerkesztse';
$strings['Checking'] = 'Ellenrzs';
$strings['You did not select anything to delete.'] = 'Nem vlasztott ki semmi trlendt.';
$strings['Added Resources'] = 'Hozzadott Kontingensek';
$strings['Additional resource is reserved'] = 'A(z) %s kiegszt kontingensbl egyszerre csak %s rhet el';
$strings['All Groups'] = 'Minden Csoport';
$strings['Group Name'] = 'Csoport Nv';
$strings['Delete Groups'] = 'Csoport Trlse';
$strings['Manage Groups'] = 'Csoport Kezels';
$strings['None'] = 'Nincs';
$strings['Group name is required.'] = 'Csoport nevnek megadsa szksgeltetik.';
$strings['Groups'] = 'Csoportok';
$strings['Current Groups'] = 'Aktulis Csoportok';
$strings['Group Administration'] = 'Csoport Karbantarts';
$strings['Reminder Subject'] = 'Vizsglati eljegyzs emlkeztet - %s, %s %s';
$strings['Reminder'] = 'Emlkeztet';
$strings['before reservation'] = 'eljegyzett vizsglat eltt';
$strings['My Participation'] = 'Rszvtel';
$strings['My Past Participation'] = 'Korbbi Rszvtel';
$strings['Timezone'] = 'Idzna';
$strings['Export'] = 'Exportls';
$strings['Select reservations to export'] = 'Vlassza ki az exportlni kvnt vizsglatot';
$strings['Export Format'] = 'Export formtum';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Ebbe a kontingensbe nem jegyezhet el %s rval korbban';
$strings['Minimum Booking Notice'] = 'Legkorbbi Eljegyzs rtest';
$strings['Maximum Booking Notice'] = 'Legksbbi Eljegyzs rtest';
$strings['hours prior to the start time'] = 'rnyira a kezd idpontig';
$strings['hours from the current time'] = 'rnyira mostantl';
$strings['Contains'] = 'Tartalmazza';
$strings['Begins with'] = 'Kezddik';
$strings['Minimum booking notice is required.'] = 'Minimum eljegyzsi figyelmeztets szksges.';
$strings['Maximum booking notice is required.'] = 'Maximum eljegyzsi figyelmeztets szksges.';
$strings['Accessory Name'] = 'Kiegszt Neve';
$strings['Accessories'] = 'Kiegsztk';
$strings['All Accessories'] = 'sszes Kiegszt';
$strings['Added Accessories'] = 'Hozzadott Kiegszt(k)';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n"
				. "Sikeresen regisztrlt a kvetkez informcikkal:\r\n"
				. "Felhasznl nv: %s\r\n"
				. "Nv: %s %s \r\n"
				. "Telefon: %s \r\n"
				. "Intzmny: %s \r\n"
				. "Beoszts: %s \r\n\r\n"
				. "Krem jelentkezzen be a Rendszerbe a kvetkez helyen:\r\n"
				. "%s \r\n\r\n"
				. "Az Online Eljegyzshez s a Profil Szerkesztshez vezet linket az Irnyt Pulton tall.\r\n\r\n"
				. "Kontingessel s eljegyzssel kapcsolatos krdseivel forduljon a kvetkezhz: %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Adminisztrátor,\r\n\r\n"
					. "Egy j Felhasznl regisztrlt s az albbi informcikat adta meg:\r\n"
					. "Email cm: %s \r\n"
					. "Nv: %s %s \r\n"
					. "Telefon: %s \r\n"
					. "Intzmny: %s \r\n"
					. "Beoszts: %s \r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n<br />"
			. "n sikeresen %s a(z) #%s szm eljeygzst.\r\n\r\n<br/><br/>"
			. "Krem hivatkozzon a megadott szmra, ha kapcsolatba kvn lpni az Adminsztrtorral.\r\n\r\n<br/><br/>"
			. "A %s %s s %s %s kztti %s eljegyzs, amely"
			. " a kvetkez helyen tallhat: %s, %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "A Vizsglat a kvetkez napokon fog ismtldni:\r\n<br/>";
$email['reservation_activity_3'] = "A csoportban elfordul sszes ismtld Vizsglat szintn %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "A kvetkez sszegzst adtk meg a Vizsglat eljegyzsekor:\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "Amennyiben ez egy tveds, krem rtestse az Adminisztrtort: %s"
			. " vagy telefonljon a kvetkez szmra: %s.\r\n\r\n<br/><br/>"
			. "Az eljegyzett Vizsglat rszleteit brmikor megnzheti vagy mdosthatja, ha"
			. " Bejelentkezik %s Rendszerbe a kvetkez helyen:\r\n<br/>"
			. "<a href=\"%s\" target=\"_blank\">%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "A technikai jelleg krdsekkel forduljon a kvetkezhz: <a href=\"mailto:%s\">%s</a>.\r\n\r\n<br/><br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n<br />"
			. "#%s szm Eljegyzs Elfogadsra kerlt.\r\n\r\n<br/><br/>"
			. "Krem hivatkozzon a megadott szmra, ha kapcsolatba kvn lpni az Adminsztrtorral.\r\n\r\n<br/><br/>"
			. "A %s %s s %s %s kztti %s eljegyzs, amely"
			. " a kvetkez helyen tallhat: %s, %s.\r\n\r\n<br/><br/>";

// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Az n %s Jelszavt az Adminisztrtor Visszalltotta.\r\n\r\n"
			. "Az n ideiglenes jelszava:\r\n\r\n %s\r\n\r\n"
			. "Krem hasznlja ezt (msolja s illessze be, hogy biztosan helyes legyen) a Belpshez %s a kvetkez helyen: %s"
			. " s vltoztassa meg nyomban a Vezrl Pult 'Profil Szerkesztse/Jelsz Megvltoztatsa' menpontjban.\r\n\r\n"
			. "Krdseivel krem keresse meg a kvetkezt: %s.";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\n"
            . "Az n j Jelszava az %s Elrshez a kvetkez:\r\n\r\n"
            . "%s\r\n\r\n"
            . "Krem jelentkezzen be a kvetkez helyen: %s"
            . "s hasznlja az jdonslt Jelszavt "
            . "(msolja s illessze be, hogy biztosan hibtlanul kerljn bevitelre) "
            . "majd a jelsz azonnali megvltoztatshoz keresse fel a "
            . "Profil Szerkesztse/Jelsz Megvltoztatsa menpontot "
            . "a Vezrl Pultban.\r\n\r\n"
            . "Krdseivel forduljon a kvetkezhz: %s.";

// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "%s Meghvta nt Rsztvevnek a kvetkez Eljegyzsbe:\r\n\r\n"
		. "Kontingens: %s\r\n"
		. "Kezd Dtum: %s\r\n"
		. "Kezd Idpont: %s\r\n"
		. "Befejez Dtum: %s\r\n"
		. "Befejez Idpont: %s\r\n"
		. "sszegzs: %s\r\n"
		. "Ismtelt Elforduls (amennyiben rvnyes): %s\r\n\r\n"
		. "A Meghvs Elfogadshoz kattintson a kvetkez linkre (msolja s illessze be, ha nem mkdik) %s\r\n"
		. "A Meghvs Visszautastshoz kvesse a kvetkez linket (msolja s illesze be, ha nem mkdik) %s\r\n"
		. "Tovbbi mveletekhez jelentkezzen be a %s Rendszerbe a kvetkez cmen: %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Az n kvetkez Eljegyzse eltvoltsra kerlt a Rendszerbl:\r\n\r\n"
		. "Kontingens: %s\r\n"
		. "Kezd Dtum: %s\r\n"
		. "Kezd Idpont: %s\r\n"
		. "Befejez Dtum: %s\r\n"
		. "Befejez Idpont: %s\r\n"
		. "sszegzs: %s\r\n"
		. "Ismtelt Elforduls (amennyiben rvnyes): %s\r\n\r\n";

// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "A kvetkez vizsglati eljegyzs ideje kzeleg: %s, %s %s - %s %s.";
?>