<?php
/**
* Slovak (sk) translation file.
*
* @author Nick Korbel <lqqkout13@users.sourceforge.net>
* @translator Marin Murn <murin@netkosice.sk>
* @version 05-20-06
* @package Languages
*
* Copyright (C) 2003 - 2007 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
// Please save the translated file as '2 letter language code'.lang.php.  For example, en.lang.php.
//
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  If there
//  is no direct translation, please provide the closest translation.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//  Also, please add a help translation for your language using en.help.php as a base.
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'windows-1250';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('Nedea', 'Pondelok', 'Utorok', 'Streda', 'tvrtok', 'Piatok', 'Sobota');
// The three letter abbreviation
$days_abbr = array('Ned', 'Pon', 'Uto', 'Str', 'tv', 'Pia', 'Sob');
// The two letter abbreviation
$days_two  = array('Ne', 'Po', 'Ut', 'St', 't', 'Pi', 'So');
// The one letter abbreviation
$days_letter = array('N', 'P', 'U', 'S', '', 'P', 'S');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('Janur', 'Februr', 'Marec', 'Aprl', 'Mj', 'Jn', 'Jl', 'August', 'September', 'Oktber', 'November', 'December');
// The three letter month name
$months_abbr = array('Jan', 'Feb', 'Mar', 'Apr', 'Mj', 'Jn', 'Jl', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%d/%m/%Y';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%d/%m/%Y @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%A %d/%m/%Y';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%A,<br/>%d/%m/%Y';
// Date on top-right of each page
$dates['header'] = '%A, %B %d, %Y';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box
$dates['jumpbox'] = '%d %m %Y';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'hodiny';
$strings['minutes'] = 'minty';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'mm';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'dd';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = 'rrrr';
$strings['am'] = 'am';
$strings['pm'] = 'pm';

$strings['Administrator'] = 'Administrator';
$strings['Welcome Back'] = 'Vitajte sp, %s';
$strings['Log Out'] = 'Odhlsi sa';
$strings['My Control Panel'] = 'Mj Riadiaci Panel';
$strings['Help'] = 'Pomoc';
$strings['Manage Schedules'] = 'Sprva rozvrhov';
$strings['Manage Users'] ='Sprva uvateov';
$strings['Manage Resources'] ='Sprva zdrojov';
$strings['Manage User Training'] ='Sprva kolen uvateov';
$strings['Manage Reservations'] ='Sprva rezervci';
$strings['Email Users'] ='Email uvateom';
$strings['Export Database Data'] = 'Export dt z databzy';
$strings['Reset Password'] = 'Reset hesla';
$strings['System Administration'] = 'Adminstrcia systmu';
$strings['Successful update'] = 'spen aktualizcia';
$strings['Update failed!'] = 'Aktualizcia nespen!';
$strings['Manage Blackout Times'] = 'Sprva asov vpadkov';
$strings['Forgot Password'] = 'Heslo zabudnut';
$strings['Manage My Email Contacts'] = 'Sprva mojich email kontaktov';
$strings['Choose Date'] = 'Vyberte dtum';
$strings['Modify My Profile'] = 'Zmeni mj profil';
$strings['Register'] = 'Registrova';
$strings['Processing Blackout'] = 'Spracovanie vpadkov';
$strings['Processing Reservation'] = 'Spracovanie rezervci';
$strings['Online Scheduler [Read-only Mode]'] = 'Online Plnova [len na tanie]';
$strings['Online Scheduler'] = 'Online Plnova';
$strings['phpScheduleIt Statistics'] = 'tatistika rezervci';
$strings['User Info'] = 'Informcie o uvateovi:';

$strings['Could not determine tool'] = 'Nebolo mon uri nstroj. Vrte sa prosm na v riadiaci panel a skuste znovu nekr.';
$strings['This is only accessable to the administrator'] = 'Toto je prstupn len pre administrtora';
$strings['Back to My Control Panel'] = 'Sp na Mj riadiaci panel';
$strings['That schedule is not available.'] = 'Tento rozvrh nie je prstupn.';
$strings['You did not select any schedules to delete.'] = 'Nevybrali ste iadny rozvrh na odstrnenie.';
$strings['You did not select any members to delete.'] = 'Nevybrali ste iadnych uvateov na odstrnenie.';
$strings['You did not select any resources to delete.'] = 'Nevybrali ste iadne zdroje na odstrnenie.';
$strings['Schedule title is required.'] = 'Nzov rozvrhu je povinn.';
$strings['Invalid start/end times'] = 'Neplatn asy zaiatku/konca';
$strings['View days is required'] = 'View days je povinn';
$strings['Day offset is required'] = 'Day offset je povinn';
$strings['Admin email is required'] = 'Email administrtora je povinn';
$strings['Resource name is required.'] = 'Nzov zdroja je povinn.';
$strings['Valid schedule must be selected'] = 'Mus by vybran platn rozvrh.';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'Minimlna dka rezervcie mus by rovnak alebo menia ne maximlna.';
$strings['Your request was processed successfully.'] = 'Vaa poiadavka bola spene spracovan.';
$strings['Go back to system administration'] = 'Sp na administrciu systmu';
$strings['Or wait to be automatically redirected there.'] = 'Alebo pokajte pokia budete automaticky presmerovan.';
$strings['There were problems processing your request.'] = 'Pri spracovan vaej poiadavky sa vyskytli problmy.';
$strings['Please go back and correct any errors.'] = 'Prosm vrte sa a opravte chyby.';
$strings['Login to view details and place reservations'] = 'Prihlste sa prosm k prehadvaniu podrobnost a zadvaniu rezervci';
$strings['Memberid is not available.'] = 'Memberid: %s nie je dostupn.';

$strings['Schedule Title'] = 'Nzov rozvrhu';
$strings['Start Time'] = 'Poiaton as';
$strings['End Time'] = 'Koncov as';
$strings['Time Span'] = 'asov rozptie';
$strings['Weekday Start'] = 'Zaiatok tda';
$strings['Admin Email'] = 'e-mail administrtora';

$strings['Default'] = 'Predvolen';
$strings['Reset'] = 'Reset';
$strings['Edit'] = 'Upravi';
$strings['Delete'] = 'Odstrni';
$strings['Cancel'] = 'Zrui';
$strings['View'] = 'Zobrazi';
$strings['Modify'] = 'Zmeni';
$strings['Save'] = 'Uloi';
$strings['Back'] = 'Sp';
$strings['Next'] = 'al';
$strings['Close Window'] = 'Zatvori okno';
$strings['Search'] = 'Hada';
$strings['Clear'] = 'Vymaza';

$strings['Days to Show'] = 'Ukza dni';
$strings['Reservation Offset'] = 'Posuv pre rezervciu';
$strings['Hidden'] = 'Skry';
$strings['Show Summary'] = 'Ukza shrn';
$strings['Add Schedule'] = 'Prida rozvrh';
$strings['Edit Schedule'] = 'Upravi rozvrh';
$strings['No'] = 'Nie';
$strings['Yes'] = 'no';
$strings['Name'] = 'Mno';
$strings['First Name'] = 'Krstn meno';
$strings['Last Name'] = 'Priezvisko';
$strings['Resource Name'] = 'Nzov zdroja';
$strings['Email'] = 'Email';
$strings['Institution'] = 'Intitcia';
$strings['Phone'] = 'Telefn';
$strings['Password'] = 'Heslo';
$strings['Permissions'] = 'Oprvnenia';
$strings['View information about'] = 'Zobrazi informciu pre: %s %s';
$strings['Send email to'] = 'Posla email komu: %s %s';
$strings['Reset password for'] = 'Reset hesla pre:  %s %s';
$strings['Edit permissions for'] = 'Upravi oprvnenia pre: %s %s';
$strings['Position'] = 'Pozcia';
$strings['Password (6 char min)'] = 'Heslo (%s znakov minimlne)';	// @since 1.1.0
$strings['Re-Enter Password'] = 'Znovu zvoli heslo';

$strings['Sort by descending last name'] = 'Zoradi zhora nadol poda priezviska';
$strings['Sort by descending email address'] = 'Zoradi zhora nadol poda emailu';
$strings['Sort by descending institution'] = 'Zoradi zhora nadol poda intitcie';
$strings['Sort by ascending last name'] = 'Zoradi zdola nahor poda priezviska';
$strings['Sort by ascending email address'] = 'Zoradi zdola nahor poda emailu';
$strings['Sort by ascending institution'] = 'Zoradi zdola nahor poda intitcie';
$strings['Sort by descending resource name'] = 'Zoradi zhora nadol poda nzvu zdroja';
$strings['Sort by descending location'] = 'Zoradi zhora nadol poda umiestnenia';
$strings['Sort by descending schedule title'] = 'Zoradi zhora nadol poda nzvu rozvrhu';
$strings['Sort by ascending resource name'] = 'Zoradi zdola nahor poda nzvu zdroja';
$strings['Sort by ascending location'] = 'Zoradi zdola nahor poda umiestnenia';
$strings['Sort by ascending schedule title'] = 'Zoradi zdola nahor poda nzvu rozvrhu';
$strings['Sort by descending date'] = 'Zoradi zhora nadol poda dtumu';
$strings['Sort by descending user name'] = 'Zoradi zhora nadol poda mena uvatea';
$strings['Sort by descending start time'] = 'Zoradi zhora nadol poda poiatonho asu';
$strings['Sort by descending end time'] = 'Zoradi zhora nadol poda koncovho asu';
$strings['Sort by ascending date'] = 'Zoradi zdola nahor poda dtumu';
$strings['Sort by ascending user name'] = 'Zoradi zdola nahor poda mena uvatea';
$strings['Sort by ascending start time'] = 'Zoradi zdola nahor poda poiatonho asu';
$strings['Sort by ascending end time'] = 'Zoradi zdola nahor poda koncovho asu';
$strings['Sort by descending created time'] = 'Zoradi zhora nadol poda asu vytvorenia';
$strings['Sort by ascending created time'] = 'Zoradi zdola nahor poda asu vytvorenia';
$strings['Sort by descending last modified time'] = 'Zoradi zhora nadol poda asu poslednej zmeny';
$strings['Sort by ascending last modified time'] = 'Zoradi zdola nahor poda asu poslednej zmeny';

$strings['Search Users'] = 'Vyhada uvatea';
$strings['Location'] = 'Umiestnenie';
$strings['Schedule'] = 'Rozvrh';
$strings['Phone'] = 'Telefn';
$strings['Notes'] = 'Poznmky';
$strings['Status'] = 'Stav';
$strings['All Schedules'] = 'Vetky rozvrhy';
$strings['All Resources'] = 'Vetky zdroje';
$strings['All Users'] = 'Vetci uvatelia';

$strings['Edit data for'] = 'Upravi dta pre: %s';
$strings['Active'] = 'Aktvny';
$strings['Inactive'] = 'Neaktvny';
$strings['Toggle this resource active/inactive'] = 'Prepnite tento zdroj - aktvny/neaktvny';
$strings['Minimum Reservation Time'] = 'Minimlna doba rezervcie';
$strings['Maximum Reservation Time'] = 'Maximlna doba rezervcie';
$strings['Auto-assign permission'] = 'Automatick priradenie oprvnenia';
$strings['Add Resource'] = 'Prida zdroj';
$strings['Edit Resource'] = 'Upravi zdroj';
$strings['Allowed'] = 'Povolen';
$strings['Notify user'] = 'Upovedomi uvatea';
$strings['User Reservations'] = 'Rezervcia uvatea';
$strings['Date'] = 'Dtum';
$strings['User'] = 'Uvate';
$strings['Email Users'] = 'Email uvateom';
$strings['Subject'] = 'Subjekt';
$strings['Message'] = 'Sprva';
$strings['Please select users'] = 'Prosm vyberte uvatea';
$strings['Send Email'] = 'Posla email';
$strings['problem sending email'] = 'Prepte, nepodarilo sa odosla v email. Skste to prosm neskr.';
$strings['The email sent successfully.'] = 'Email bol spene odoslan.';
$strings['do not refresh page'] = 'Prosm <u>neobnovujte</u> tto strnku. Email by bol poslan znovu.';
$strings['Return to email management'] = 'Sp ku sprve emailu';
$strings['Please select which tables and fields to export'] = 'Prosm vyberte tabuky a polia pre export:';
$strings['all fields'] = '- vetky polia -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Obyajn text';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'Export dt';
$strings['Reset Password for'] = 'Reset hesla pre: %s';
$strings['Please edit your profile'] = 'Prosm, upravte v profil';
$strings['Please register'] = 'Prosm, zaregistrujte sa';
$strings['Keep me logged in'] = 'Udrujte ma prihlsenho<br/>(vyaduje cookies)';
$strings['Edit Profile'] = 'Upravi profil';
$strings['Register'] = 'Registrcia';
$strings['Please Log In'] = 'Prosm, prihlste sa';
$strings['Email address'] = 'Emailov adresa';
$strings['Password'] = 'Heslo';
$strings['First time user'] = 'Prvkrt pripojen?';
$strings['Click here to register'] = 'Kliknite tu pre registrciu';
$strings['Register for phpScheduleIt'] = 'Registrcia pre rezervcie';
$strings['Log In'] = 'Prihlsenie';
$strings['View Schedule'] = 'Zobrazi rozvrh';
$strings['View a read-only version of the schedule'] = 'Verzia rozvrhu len na tanie';
$strings['I Forgot My Password'] = 'Zabudol som svoje heslo';
$strings['Retreive lost password'] = 'Zskanie stratenho hesla';
$strings['Get online help'] = 'Online pomoc';
$strings['Language'] = 'Jazyk';
$strings['(Default)'] = '(Predvolen)';

$strings['My Announcements'] = 'Moje oznmenia';
$strings['My Reservations'] = 'Moje rezervcie';
$strings['My Permissions'] = 'Moje oprvnenia';
$strings['My Quick Links'] = 'Moje rchle odkazy';
$strings['Announcements as of'] = 'Oznmenia: %s';
$strings['There are no announcements.'] = 'iadne oznmenia.';
$strings['Resource'] = 'Zdroj';
$strings['Created'] = 'Vytvoren';
$strings['Last Modified'] = 'Posledn zmena';
$strings['View this reservation'] = 'Zobrazi tto rezervciu';
$strings['Modify this reservation'] = 'Zmeni tto rezervciu';
$strings['Delete this reservation'] = 'Odstrni tto rezervciu';
$strings['Bookings'] = 'Rezervcie';											// @since 1.2.0
$strings['Change My Profile Information/Password'] = 'Zmena profilu';		// @since 1.2.0
$strings['Manage My Email Preferences'] = 'Nastavenia Emailu';				// @since 1.2.0
$strings['Mass Email Users'] = 'Hromadn email uvateom';
$strings['Search Scheduled Resource Usage'] = 'Hada rezervcie';		// @since 1.2.0
$strings['Export Database Content'] = 'Export obsahu databzy';
$strings['View System Stats'] = 'Zobrazi tatistiku systmu';
$strings['Email Administrator'] = 'Email administrtorovi';

$strings['Email me when'] = 'Poli mi email, ke:';
$strings['I place a reservation'] = 'Zadm rezervciu';
$strings['My reservation is modified'] = 'Moja rezervcia je zmenen';
$strings['My reservation is deleted'] = 'Moja rezervcia je odstrnen';
$strings['I prefer'] = 'Uprednostujem:';
$strings['Your email preferences were successfully saved'] = 'Vae emailov nastavenia boli spene uloen!';
$strings['Return to My Control Panel'] = 'Sp na Mj riadiaci panel';

$strings['Please select the starting and ending times'] = 'Prosm zvote poiaton a koncov asy:';
$strings['Please change the starting and ending times'] = 'Prosm zmete poiaton a koncov asy:';
$strings['Reserved time'] = 'Rezervovan as:';
$strings['Minimum Reservation Length'] = 'Dka minimlnej rezervcie:';
$strings['Maximum Reservation Length'] = 'Dka maximlnej rezervcie:';
$strings['Reserved for'] = 'Rezervovan pre:';
$strings['Will be reserved for'] = 'Bude rezervovan pre:';
$strings['N/A'] = 'N/A';
$strings['Update all recurring records in group'] = 'Aktualizova vetky opakujce sa zznamy pre  skupinu?';
$strings['Delete?'] = 'Odstrni?';
$strings['Never'] = '-- Nikdy --';
$strings['Days'] = 'Dni';
$strings['Weeks'] = 'Tdne';
$strings['Months (date)'] = 'Mesiace (dtum)';
$strings['Months (day)'] = 'Mesiace (den)';
$strings['First Days'] = 'Prv dni';
$strings['Second Days'] = 'Druh dni';
$strings['Third Days'] = 'Tretie dni';
$strings['Fourth Days'] = 'tvrt dni';
$strings['Last Days'] = 'Posledn dni';
$strings['Repeat every'] = 'Opakuj kad:';
$strings['Repeat on'] = 'Opakuj ke:';
$strings['Repeat until date'] = 'Opakuj do dtumu:';
$strings['Choose Date'] = 'Vyberte dtum';
$strings['Summary'] = 'Shrn';

$strings['View schedule'] = 'Zobrazi rozvrh:';
$strings['My Reservations'] = 'Moje rezervcie';
$strings['My Past Reservations'] = 'Moje minul rezervcie';
$strings['Other Reservations'] = 'alie rezervcie';
$strings['Other Past Reservations'] = 'alie minul rezervcie';
$strings['Blacked Out Time'] = 'Vpadkov as';
$strings['Set blackout times'] = 'Nastavi vpadkov asy pre %s na %s';
$strings['Reserve on'] = 'Rezervova %s na %s';
$strings['Prev Week'] = '&laquo; Predchdzajci tde';
$strings['Jump 1 week back'] = 'Skoit 1 tde sp';
$strings['Prev days'] = '&#8249; Predch. %d dni';
$strings['Previous days'] = '&#8249; Predchdzajce %d dni';
$strings['This Week'] = 'Tento tde';
$strings['Jump to this week'] = 'Skoi do tohto tda';
$strings['Next days'] = 'alch %d dn &#8250;';
$strings['Next Week'] = 'al tde &raquo;';
$strings['Jump To Date'] = 'Skoi na dtum';
$strings['View Monthly Calendar'] = 'Zobrazi mesan kalendr';
$strings['Open up a navigational calendar'] = 'Otvori navigan kalendr';

$strings['View stats for schedule'] = 'Zobrazi tatistiku pre rozvrh:';
$strings['At A Glance'] = 'Zbene';
$strings['Total Users'] = 'Celkovo uvatelia:';
$strings['Total Resources'] = 'Celkovo zdroje:';
$strings['Total Reservations'] = 'Celkovo rezervcie:';
$strings['Max Reservation'] = 'Max rezervcie:';
$strings['Min Reservation'] = 'Min rezervcie:';
$strings['Avg Reservation'] = 'Priemern rezervcie:';
$strings['Most Active Resource'] = 'Najaktvnej zdroj:';
$strings['Most Active User'] = 'Najaktvnej uvate:';
$strings['System Stats'] = 'tatistika systmu';
$strings['phpScheduleIt version'] = 'Verzia phpScheduleIt:';
$strings['Database backend'] = 'Pouit databzov systm:';
$strings['Database name'] = 'Nzov databzy:';
$strings['PHP version'] = 'Verzia PHP:';
$strings['Server OS'] = 'OS serveru:';
$strings['Server name'] = 'Nzov serveru:';
$strings['phpScheduleIt root directory'] = 'Koreov adresr systmu:';
$strings['Using permissions'] = 'Pouvan oprvnenia:';
$strings['Using logging'] = 'Pouvan logovania:';
$strings['Log file'] = 'Logovac sbor:';
$strings['Admin email address'] = 'Email administrtora:';
$strings['Tech email address'] = 'Email technickej podpory:';
$strings['CC email addresses'] = 'CC emailov adresy:';
$strings['Reservation start time'] = 'Poiaton as rezervcie:';
$strings['Reservation end time'] = 'Koncov as rezervcie:';
$strings['Days shown at a time'] = 'Poet naraz zobrazovanch dn:';
$strings['Reservations'] = 'Rezervcie';
$strings['Return to top'] = 'Sp na zaiatok';
$strings['for'] = 'pre';

$strings['Select Search Criteria'] = 'Vyberte vyhadvacie kritri';
$strings['Schedules'] = 'Rozvrhy:';
$strings['All Schedules'] = 'Vetky rozvrhy';
$strings['Hold CTRL to select multiple'] = 'Drte CTRL k viacnsobnmu vberu';
$strings['Users'] = 'Uvatelia:';
$strings['All Users'] = 'Vetci uvatelia';
$strings['Resources'] = 'Zdroje';
$strings['All Resources'] = 'Vetky zdroje';
$strings['Starting Date'] = 'Poiaton dtum:';
$strings['Ending Date'] = 'Koncov dtum:';
$strings['Starting Time'] = 'Poiaton as:';
$strings['Ending Time'] = 'Koncov as:';
$strings['Output Type'] = 'Typ vstupu:';
$strings['Manage'] = 'Spravova';
$strings['Total Time'] = 'Celkov as';
$strings['Total hours'] = 'Spolu hodn:';
$strings['% of total resource time'] = '% celkovho asu zdroja';
$strings['View these results as'] = 'Zobrazi tieto vsledky ako:';
$strings['Edit this reservation'] = 'Upravi tto rezervciu';
$strings['Search Results'] = 'Prehada vsledky';
$strings['Search Resource Usage'] = 'Vyhada vyuitie zdroja';
$strings['Search Results found'] = 'Vsledky vyhadvania: %d rezervcii njdench';
$strings['Try a different search'] = 'Skste in vyhadvanie';
$strings['Search Run On'] = 'Spusti vyhadvanie na:';
$strings['Member ID'] = 'ID uvatea';
$strings['Previous User'] = '&laquo; Predchdzajci uvate';
$strings['Next User'] = 'Dal uvate &raquo;';

$strings['No results'] = 'iadne vsledky';
$strings['That record could not be found.'] = 'Tento zznam sa nenaiel.';
$strings['This blackout is not recurring.'] = 'Tento vpadok nie je opakovan.';
$strings['This reservation is not recurring.'] = 'Tto rezervcia nie je opakovan.';
$strings['There are no records in the table.'] = 'V tabuke %s nie s iadne zznamy.';
$strings['You do not have any reservations scheduled.'] = 'Nemte naplnovan iadne rezervcie.';
$strings['You do not have permission to use any resources.'] = 'Nemte oprvnenie pouva akkovek zdroj.';
$strings['No resources in the database.'] = 'V databze nie s iadne zdroje.';
$strings['There was an error executing your query'] = 'Pri spracovvan vaej poiadavky dolo k  chybe:';

$strings['That cookie seems to be invalid'] = 'Tento cookie je neplatn';
$strings['We could not find that logon in our database.'] = 'Toto prihlsenie sa v naej databze nenalo.';	// @since 1.1.0
$strings['That password did not match the one in our database.'] = 'Toto heslo sa nezhodovalo s heslom z naej databzy.';
$strings['You can try'] = '<br />Mete vyska:<br />Registrova email adresu.<br />Alebo:<br />Skste prihlsenie znovu.';
$strings['A new user has been added'] = 'Nov uvate bol pridan';
$strings['You have successfully registered'] = 'spene ste sa zaregistrovali!';
$strings['Continue'] = 'Pokraova...';
$strings['Your profile has been successfully updated!'] = 'V profil bol spene zmenen!';
$strings['Please return to My Control Panel'] = 'Prosm vrte sa na Mj riadiaci panel';
$strings['Valid email address is required.'] = '- je poadovan platn emailov adresa.';
$strings['First name is required.'] = '- Krstn meno je poadovan.';
$strings['Last name is required.'] = '- Priezvisko je poadovan.';
$strings['Phone number is required.'] = '- Telefnne slo je poadovan.';
$strings['That email is taken already.'] = '- Tto emailov adresa u existuje.<br />Prosm zadajte in emailov adresu.';
$strings['Min 6 character password is required.'] = '- Je poadovan heslo s minimlne %s znakmi.';
$strings['Passwords do not match.'] = '- Hesl sa nezhoduj.';

$strings['Per page'] = 'Na strnku:';
$strings['Page'] = 'Strnka:';

$strings['Your reservation was successfully created'] = 'Vaa rezervcia bola spene vytvoren';
$strings['Your reservation was successfully modified'] = 'Vaa rezervcia bola spene zmenen';
$strings['Your reservation was successfully deleted'] = 'Vaa rezervcia bola spene odstrnen';
$strings['Your blackout was successfully created'] = 'V vpadok bol spene vytvoren';
$strings['Your blackout was successfully modified'] = 'V vpadok bol spene zmenen';
$strings['Your blackout was successfully deleted'] = 'V vpadok bol spene odstrnen';
$strings['for the follwing dates'] = 'pre nasledujce dta:';
$strings['Start time must be less than end time'] = 'Poiaton as mus by men ne koncov as.';
$strings['Current start time is'] = 'Aktulny poiaton as je:';
$strings['Current end time is'] = 'Aktulny koncov as je:';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'Dka rezervcie nie je v intervale povolenej dky pre tento zdroj.';
$strings['Your reservation is'] = 'Vaa rezervcia je:';
$strings['Minimum reservation length'] = 'Minimlna dka rezervcie:';
$strings['Maximum reservation length'] = 'Maximlna dka rezervcie:';
$strings['You do not have permission to use this resource.'] = 'Nemte oprvnenie k pouvaniu tohto zdroja.';
$strings['reserved or unavailable'] = '%s a %s je rezervovan alebo neprstupn.';	// @since 1.1.0
$strings['Reservation created for'] = 'Rezervcia vytvoren pre %s';
$strings['Reservation modified for'] = 'Rezervcia zmenen pre %s';
$strings['Reservation deleted for'] = 'Rezervcia odstrnen pre %s';
$strings['created'] = 'vytvoren';
$strings['modified'] = 'zmenen';
$strings['deleted'] = 'odstrnen';
$strings['Reservation #'] = 'Rezervcia #';
$strings['Contact'] = 'Kontakt';
$strings['Reservation created'] = 'Rezervcia vytvoren';
$strings['Reservation modified'] = 'Rezervcia zmenen';
$strings['Reservation deleted'] = 'Rezervcia odstrnen';

$strings['Reservations by month'] = 'Rezervcie po mesiacoch';
$strings['Reservations by day of the week'] = 'Rezervcie po doch v tdni';
$strings['Reservations per month'] = 'Rezervcie po doch v mesiaci';
$strings['Reservations per user'] = 'Rezervcie na uvatea';
$strings['Reservations per resource'] = 'Rezervcie na zdroj';
$strings['Reservations per start time'] = 'Rezervcie poda poiatonho asu';
$strings['Reservations per end time'] = 'Rezervcie poda koncovho asu';
$strings['[All Reservations]'] = '[Vetky rezervcie]';

$strings['Permissions Updated'] = 'Oprvnenia aktualizovan';
$strings['Your permissions have been updated'] = 'Vae %s oprvnenia boli aktualizovan';
$strings['You now do not have permission to use any resources.'] = 'Teraz nemte oprvnenie k pouitiu iadneho zdroja.';
$strings['You now have permission to use the following resources'] = 'Teraz mte oprvnenie k pouitiu nsledujceho zdroja:';
$strings['Please contact with any questions.'] = 'Prosm kontaktujte %s s ubovonou poiadavkou.';
$strings['Password Reset'] = 'Reset hesla';

$strings['This will change your password to a new, randomly generated one.'] = 'Toto zmen vae heslo na nov, nhodne vygenerovan.';
$strings['your new password will be set'] = 'Po vloen vho emailu a kliknut na "Zmeni heslo" vm systm nastav nov heslo a zale ho emailom.';
$strings['Change Password'] = 'Zmeni heslo';
$strings['Sorry, we could not find that user in the database.'] = 'Prepte, tohoto uvatea sme nenali v databze.';
$strings['Your New Password'] = 'Vae nov %s heslo';
$strings['Your new passsword has been emailed to you.'] = 'spech!<br />'
    			. 'Vae nov heslo vm bolo poslan emailom.<br />'
    			. 'Prosm skontrolujte si vau emailov schrnku, kde bude nov heslo, potom sa <a href="index.php">prihlste</a>'
    			. ' s tmto novm heslom a urchlene ho zmete kliknutm na odkaz &quot;Zmeni mj profil/heslo&quot;'
    			. ' v oblasti Mj riadiaci panel.';

$strings['You are not logged in!'] = 'Nie ste prihlsen!';

$strings['Setup'] = 'Nastavenie';
$strings['Please log into your database'] = 'Prosm prihlste sa do vaej databzy';
$strings['Enter database root username'] = 'Vlote uvatesk meno administrtora databzy:';
$strings['Enter database root password'] = 'Vlote heslo administrtora databzy:';
$strings['Login to database'] = 'Prihlsenie do databzy';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = 'Administrtorsk prva <b>nie s potrebn</b>. Ktorkovek uvate databzy s prvom vytvra tabuky postauje.';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'Toto nastav potrebn databzy a tabuky pre phpScheduleIt.';
$strings['It also populates any required tables.'] = 'Toto tie vypln potrebn tabuky.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Varovanie: TOTO ODSTRNI VETKY DTA V PREDCHDZAJCICH DATABZACH phpScheduleIt!';
$strings['Not a valid database type in the config.php file.'] = 'Neplatn typ databzy v sbore config.php.';
$strings['Database user password is not set in the config.php file.'] = 'Heslo pre uvatea databzy nie je nastaven v sbore config.php.';
$strings['Database name not set in the config.php file.'] = 'Nzov databzy nie je nastaven v sbore config.php.';
$strings['Successfully connected as'] = 'spene pripojen ako';
$strings['Create tables'] = 'Vytvori tabuky &gt;';
$strings['There were errors during the install.'] = 'Behom intalcie sa vyskytly chyby. Je mon, e phpScheduleIt bude aj tak fungova, pokia chyby neboli zvan.<br/><br/>'
	. 'Prosm akkovek dotazy uvdzajte v diskusnch frach na <a href="http://sourceforge.net/forum/?group_id=95547">SourceForge</a>.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'spene ste dokonili nastavenie phpScheduleIt a mete ho zaa pouva.';
$strings['Thank you for using phpScheduleIt'] = 'Prosm zabezpete PLN ODSTRNENIE ADRESRA \'install\' .'
	. ' To je vemi dleit, pretoe obsahuje hesl do databzy a alie citliv informcie.'
	. ' Pokia to nezabezpete, nechte tak otvoren dvere k preniknutiu do vaej databzy!'
	. '<br /><br />'
	. 'akujeme vm, e pouvate phpScheduleIt!';
$strings['There is no way to undo this action'] = 'Tto akciu nie je mon vrti sp!';
$strings['Click to proceed'] = 'Kliknite pre pokraovanie';
$strings['Please delete this file.'] = 'Prosm odstrte tento sbor.';
$strings['Successful update'] = 'Aktualizcia prebehla vporiadku';
$strings['Patch completed successfully'] = 'Zplata bola spene aplikovan';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'Pokia nie je uveden iadna hodnota, bude pouit heslo uveden v konfiguranom sbore.';
$strings['Notify user that password has been changed?'] = 'Upovedomi uvatea, e heslo bolo zmenen?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'Tento systm vyaduje, aby ste mali emailov adresu.';
$strings['Invalid User Name/Password.'] = 'Neplatn uvatesk meno/heslo.';
$strings['Pending User Reservations'] = 'Nevybaven uvatesk rezervcie';
$strings['Approve'] = 'Schvli';
$strings['Approve this reservation'] = 'Schvli tto rezervciu';
$strings['Approve Reservations'] ='Schvli rezervcie';

$strings['Announcement'] = 'Oznmenie';
$strings['Number'] = 'slo';
$strings['Add Announcement'] = 'Prida oznmenie';
$strings['Edit Announcement'] = 'Upravi oznmenie';
$strings['All Announcements'] = 'Vetky oznmenia';
$strings['Delete Announcements'] = 'Odstrni oznmenia';
$strings['Use start date/time?'] = 'Poui poiaton dtum/as?';
$strings['Use end date/time?'] = 'Poui koncov dtum/as?';
$strings['Announcement text is required.'] = 'Text oznmenia je poadovan.';
$strings['Announcement number is required.'] = 'slo oznmenia je poadovan.';

$strings['Pending Approval'] = 'Nevybaven schvlenie';
$strings['My reservation is approved'] = 'Moja rezervcia je schvlen';
$strings['This reservation must be approved by the administrator.'] = 'Tto rezervcia mus by schvlen administrtorom.';
$strings['Approval Required'] = 'Schvlenie je poadovan';
$strings['No reservations requiring approval'] = 'iadne rezervcie na schvlenie';
$strings['Your reservation was successfully approved'] = 'Vaa rezervcia bola spene schvlen';
$strings['Reservation approved for'] = 'Rezervcia schvlen pre %s';
$strings['approved'] = 'schvlen';
$strings['Reservation approved'] = 'Rezervcia schvlen';

$strings['Valid username is required'] = 'Je poadovan platn uvatesk meno';
$strings['That logon name is taken already.'] = 'Toto prihlasovacie meno je u pouvan.';
$strings['this will be your login'] = '(toto bude vae prihlasovacie meno)';
$strings['Logon name'] = 'Prihlasovacie meno';
$strings['Your logon name is'] = 'Vae prihlasovacie meno je %s';

$strings['Start'] = 'Zaiatok';
$strings['End'] = 'Koniec';
$strings['Start date must be less than or equal to end date'] = 'Poiaton dtum mus by men alebo rovn koncovmu dtumu';
$strings['That starting date has already passed'] = 'Poiaton dtum u uplynul';
$strings['Basic'] = 'Zkladn';
$strings['Participants'] = 'astnci';
$strings['Close'] = 'Zatvori';
$strings['Start Date'] = 'Poiaton dtum';
$strings['End Date'] = 'Koncov dtum';
$strings['Minimum'] = 'Minimum';
$strings['Maximum'] = 'Maximum';
$strings['Allow Multiple Day Reservations'] = 'Povoli viacdov rezervcie';
$strings['Invited Users'] = 'Pozvan uvatelia';
$strings['Invite Users'] = 'Pozva uvateov';
$strings['Remove Participants'] = 'Odstrni astnkov';
$strings['Reservation Invitation'] = 'Pozvanie Rezervcie';
$strings['Manage Invites'] = 'Sprva pozvnok';
$strings['No invite was selected'] = 'Neboli vybran iadne pozvnky';
$strings['reservation accepted'] = '%s Vae pozvanie na %s prijat';
$strings['reservation declined'] = '%s Vae pozvanie na %s zamietnut';
$strings['Login to manage all of your invitiations'] = 'Prihlste sa ku sprve vetkch Vaich pozvan';
$strings['Reservation Participation Change'] = 'Zmena asti na rezervcii';
$strings['My Invitations'] = 'Moje pozvania';
$strings['Accept'] = 'Prija';
$strings['Decline'] = 'Zamietnu';
$strings['Accept or decline this reservation'] = 'Prija alebo zamietnu tto rezervciu';
$strings['My Reservation Participation'] = 'Moja as na rezervcii';
$strings['End Participation'] = 'Koniec asti';
$strings['Owner'] = 'Vlastnk';
$strings['Particpating Users'] = 'Zastnen uvatelia';
$strings['No advanced options available'] = 'iadne pokroil voby nie s prstupn';
$strings['Confirm reservation participation'] = 'Potvrte as na rezervcii';
$strings['Confirm'] = 'Potvrdi';
$strings['Do for all reservations in the group?'] = 'Vykona pre vetky rezervcie v skupine?';

$strings['My Calendar'] = 'Mj kalendr';
$strings['View My Calendar'] = 'Zobrazi Mj kalendr';
$strings['Participant'] = 'astnk';
$strings['Recurring'] = 'Opakujci sa';
$strings['Multiple Day'] = 'Viacej dn';
$strings['[today]'] = '[dnes]';
$strings['Day View'] = 'Zobrazenie da';
$strings['Week View'] = 'Zobrazenie tda';
$strings['Month View'] = 'Zobrazenie mesiaca';
$strings['Resource Calendar'] = 'Kalendr zdrojov';
$strings['View Resource Calendar'] = 'Plnovac kalendr';	// @since 1.2.0
$strings['Signup View'] = 'Zobrazenie registrcie';

$strings['Select User'] = 'Vybra uvatea';
$strings['Change'] = 'Zmeni';

$strings['Update'] = 'Aktualizova';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'Aktualizcia  phpScheduleIt je dostupn len pre verziu 1.0.0 a vyie';
$strings['phpScheduleIt is already up to date'] = 'phpScheduleIt je aktualizovan';
$strings['Migrating reservations'] = 'Migrujce rezervcie';

$strings['Admin'] = 'Admin';
$strings['Manage Announcements'] = 'Spravovanie oznmen';
$strings['There are no announcements'] = 'Nie s iadne oznmenia';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Maximlna kapacita astnkov';
$strings['Leave blank for unlimited'] = 'Nevyplajte pre neobmedzen poet';
$strings['Maximum of participants'] = 'Tento zdroj m maximlnu kapacitu %s astnkov';
$strings['That reservation is at full capacity.'] = 'Tto rezervcia je obsaden.';
$strings['Allow registered users to join?'] = 'Umoni pridanie pre registrovanch uvateov?';
$strings['Allow non-registered users to join?'] = 'Umoni pridanie pre neregistrovanch uvateov?';
$strings['Join'] = 'Prida sa';
$strings['My Participation Options'] = 'Nastavenia pre moju as';
$strings['Join Reservation'] = 'Prida sa k rezervcii';
$strings['Join All Recurring'] = 'Prida sa ku vetkm opakujcim';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'Nie ste astnkom nasledujcich rezervanch termnov, pretoe s obsaden.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'U ste boli pozvan k tejto rezervcii. Pozrite si prosm intrukcie pre as, ktor boli poslan na Vau emailov adresu.';
$strings['Additional Tools'] = 'Doplnkov nstroje';
$strings['Create User'] = 'Vytvori uvatea';
$strings['Check Availability'] = 'Skontrolova dostupnos';
$strings['Manage Additional Resources'] = 'Sprva dodatocnch zdrojov';
$strings['Number Available'] = 'Poet dostupnch';
$strings['Unlimited'] = 'Neobmedzen';
$strings['Add Additional Resource'] = 'Pridat dodatocn zdroj';
$strings['Edit Additional Resource'] = 'Zmenit dodatocn zdroj';
$strings['Checking'] = 'Overenie';
$strings['You did not select anything to delete.'] = 'Nevybrali ste ni na zmazanie.';
$strings['Added Resources'] = 'Pridan zdroje';
$strings['Additional resource is reserved'] = 'Dodaton zdroj %s m dostupnch len %s v tomto ase';
$strings['All Groups'] = 'Vetky skupiny';
$strings['Group Name'] = 'Meno skupiny';
$strings['Delete Groups'] = 'Zmaza skupiny';
$strings['Manage Groups'] = 'Spravovanie skupn';
$strings['None'] = 'iadny';
$strings['Group name is required.'] = 'Je poadovan meno skupiny.';
$strings['Groups'] = 'Skupiny';
$strings['Current Groups'] = 'Aktulne skupiny';
$strings['Group Administration'] = 'Skupinov administrcia';
$strings['Reminder Subject'] = 'Pripomienkova pre rezervciu- %s, %s %s';
$strings['Reminder'] = 'Pripomienkova';
$strings['before reservation'] = 'pred rezervciou';
$strings['My Participation'] = 'Moja as';
$strings['My Past Participation'] = 'Moja posledn as';
$strings['Timezone'] = 'asov psmo';
$strings['Export'] = 'Export';
$strings['Select reservations to export'] = 'Vyberte rezervcie na export';
$strings['Export Format'] = 'Formt exportu';
$strings['This resource cannot be reserved less than x hours in advance'] = 'Tento zdroj nesmie by rezervovan menej ne %s hodn vopred';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Tento zdroj nesmie by rezervovan viac ne %s hodn vopred';
$strings['Minimum Booking Notice'] = 'Minimlny poet oznamov pre rezervciu';
$strings['Maximum Booking Notice'] = 'Maximlny poet oznamov pre rezervciu';
$strings['hours prior to the start time'] = 'hodn pred poiatonm asom';
$strings['hours from the current time'] = 'hodn od aktulneho asu';
$strings['Contains'] = 'Obsahuje';
$strings['Begins with'] = 'Zana s';
$strings['Minimum booking notice is required.'] = 'Minimlny poet oznamov pre rezervciu je poadovan.';
$strings['Maximum booking notice is required.'] = 'Maximlny poet oznamov pre rezervciu je poadovan.';
$strings['Accessory Name'] = 'Meno doplnku';
$strings['Accessories'] = 'Doplnky';
$strings['All Accessories'] = 'Vetky doplnky';
$strings['Added Accessories'] = 'Pridan doplnky';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n"
				. "Boli ste spene zaregistrovan s nsledujucmi dajmi:\r\n"
				. "Prihlasovacie meno: %s\r\n"
				. "Meno: %s %s \r\n"
				. "Telefn: %s \r\n"
				. "Intitcia: %s \r\n"
				. "Pozcia: %s \r\n\r\n"
				. "Prosm prihlste sa pre vyuvanie Plnovaa na tejto adrese:\r\n"
				. "%s \r\n\r\n"
				. "Upravi svoj profil a njs odkazy na online Plnova mete v sekcii Mj riadiaci panel.\r\n\r\n"
				. "Polite prosm akkovek otzky ohadom zdrojov alebo rezervci na adresu %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Administrtor,\r\n\r\n"
					. "Bol zaregistrovan nov uvate s nasledujcimi dajmi:\r\n"
					. "Email: %s \r\n"
					. "Meno: %s %s \r\n"
					. "Telefn: %s \r\n"
					. "Intitcia: %s \r\n"
					. "Pozcia: %s \r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n<br />"
			. "Mte spen %s rezervciu #%s.\r\n\r\n<br/><br/>"
			. "Pouvajte prosm toto slo rezervcie pri kontakte administrtora s akoukovek  otzkou.\r\n\r\n<br/><br/>"
			. "Rezervcia medzi %s %s a %s %s pre %s"
			. " v mieste %s bola %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "Tto rezervcia sa opakuje v nasledujce dni:\r\n<br/>";
$email['reservation_activity_3'] = "Vetky opakujce sa rezervcie v tejto skupine boli tak %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "Pre tto rezervciu bol poskytnut nasledujci shrn :\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "Pokia ide o chybu, kontaktujte prosm administrtora na: %s"
			. " alebo volajte  %s.\r\n\r\n<br/><br/>"
			. "Informcie o vaej rezervcii mete prezera alebo meni kedykovek po"
			. " prihlsen do %s na adrese:\r\n<br/>"
			. "<a href=\"%s\" target=\"_blank\">%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "Vetky technick otzky smerujte na <a href=\"mailto:%s\">%s</a>.\r\n\r\n<br/><br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n<br />"
			. "Rezervcia #%s bola schvlen.\r\n\r\n<br/><br/>"
			. "Prosm pouvajte toto slo rezervcie pri kontakte administrtora s akoukovek  otzkou.\r\n\r\n<br/><br/>"
			. "Rezervcia medzi %s %s a %s %s pre %s"
			. " umiestnen v %s bola %s.\r\n\r\n<br/><br/>";

// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Vae %s heslo bolo resetovan administrtorom.\r\n\r\n"
			. "Vae doasn heslo je:\r\n\r\n %s\r\n\r\n"
			. "Prosm pouijte toto doasn heslo (k zabezpeeniu sprvnosti pouijte funkciu pravy | Koprova a Vloit) pre prihlsenie do %s na %s"
			. " a okamite ho zmete pomocou odkazu 'Zmeni Mj profil/Heslo' z tabuky Moje rchle odkazy.\r\n\r\n"
			. "Prosm, kontaktujte %s s akoukovek poiadavkou.";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\n"
            . "Vae nov heslo pre v %s et je:\r\n\r\n"
            . "%s\r\n\r\n"
            . "Prosm, prihlste se na %s "
            . "s tmto heslom "
            . "(k zabezpeeniu sprvnosti pouijte funkciu pravy | Koprova a Vloi) "
            . "a okamite zmete vae heslo kliknutm na "
            . "odkaz Zmeni Mj profil/Heslo "
            . "v sekcii Mj riadiaci panel.\r\n\r\n"
            . "Prosm, akkovek poiadavky smerujte na %s.";

// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "%s vs pozval k asti pre nsledujcu rezervciu:\r\n\r\n"
		. "Zdroj: %s\r\n"
		. "Poiaton dtum: %s\r\n"
		. "Poiaton as: %s\r\n"
		. "Koncov dtum: %s\r\n"
		. "Koncov as: %s\r\n"
		. "Shrn: %s\r\n"
		. "Opakovan dta (pokia s dostupn): %s\r\n\r\n"
		. "Pre prijatie tejto pozvnky kliknite na tento odkaz (Koprujte a Vlote, pokia nie je zvraznen) %s\r\n"
		. "Pre odmietnutie tejto pozvnky kliknite na tento link (Koprujte a Vlote, pokia nie je zvraznen) %s\r\n"
		. "Pre neskorie prijatie vybranch dt alebo sprvu pozvnok sa prihlaste do %s na %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Boli ste odstrnen z nsledujcej rezervcie:\r\n\r\n"
		. "Zdroj: %s\r\n"
		. "Poiaton dtum: %s\r\n"
		. "Poiaton as: %s\r\n"
		. "Koncov dtum: %s\r\n"
		. "Koncov as: %s\r\n"
		. "Shrn: %s\r\n"
		. "Opakovan dta (pokia s dostupn): %s\r\n\r\n";

// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "Vaa rezervcia pre %s od %s %s do %s %s sa bli.";
?>